/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroLeavePartyEvent;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.ManaUpdater;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.skill.DelayedSkill;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.PassiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.CommandHandler;
import com.herocraftonline.heroes.storage.Storage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CharacterManager {
    private final Heroes plugin;
    private final Map<String, Hero> heroes;
    private Storage storage;
    private static final int manaInterval = 5;
    private static final int warmupInterval = 5;
    private final DelayQueue<DelayedSkill> delayedSkillQueue;
    private final Map<UUID, Monster> monsters;
    private final BukkitTask taskId;
    private static final long QUICK_REAPER_DELAY = 400L;

    public CharacterManager(Heroes plugin) {
        this.plugin = plugin;
        this.heroes = new HashMap<String, Hero>();
        this.monsters = new ConcurrentHashMap<UUID, Monster>();
        this.taskId = plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, (Runnable)new EntityReaper(), 100L, 100L);
        this.storage = plugin.getStorageManager().getStorage();
        long regenInterval = (long)Heroes.properties.manaRegenInterval * 1000L;
        ManaUpdater manaTimer = new ManaUpdater(this, regenInterval);
        plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)manaTimer, 0L, 5L);
        this.delayedSkillQueue = new DelayQueue();
        DelayedSkillExecuter delayedExecuter = new DelayedSkillExecuter();
        plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)delayedExecuter, 0L, 5L);
    }

    public CharacterTemplate getCharacter(LivingEntity lEntity) {
        if (lEntity instanceof Player) {
            return this.getHero((Player)lEntity);
        }
        return this.getMonster(lEntity);
    }

    public Monster getMonster(LivingEntity lEntity) {
        UUID id = lEntity.getUniqueId();
        if (this.monsters.containsKey(id)) {
            return this.monsters.get(id);
        }
        Monster monster = new Monster(this.plugin, lEntity);
        this.monsters.put(id, monster);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new EntityQuickReaper(monster), 400L);
        return monster;
    }

    public Monster getMonster(UUID id) {
        return this.monsters.get(id);
    }

    protected Hero addHero(Hero hero) {
        this.heroes.put(hero.getPlayer().getName(), hero);
        return hero;
    }

    public Hero getHero(Player player) {
        Hero hero = this.heroes.get(player.getName());
        if (hero != null) {
            if (hero.getPlayer().getEntityId() != player.getEntityId()) {
                if (Heroes.properties.debug) {
                    Heroes.log(Level.SEVERE, "Hero with duplicate player object detected and reloaded, you have a plugin causing duplicate player objects!");
                }
                hero.setPlayer(player);
                hero.clearEffects();
                this.performSkillChecks(hero);
                return hero;
            }
            return hero;
        }
        hero = this.storage.loadHero(player);
        this.addHero(hero);
        this.performSkillChecks(hero);
        return hero;
    }

    public void checkClasses(Hero hero) {
        Player player = hero.getPlayer();
        HeroClass playerClass = hero.getHeroClass();
        HeroClass secondClass = hero.getSecondClass();
        if (!CommandHandler.hasPermission((CommandSender)player, "heroes.classes." + playerClass.getName().toLowerCase())) {
            hero.setHeroClass(this.plugin.getClassManager().getDefaultClass(), false);
        }
        if (secondClass != null && !CommandHandler.hasPermission((CommandSender)player, "heroes.classes." + secondClass.getName().toLowerCase())) {
            hero.setHeroClass(null, true);
        }
    }

    public Collection<Hero> getHeroes() {
        return Collections.unmodifiableCollection(this.heroes.values());
    }

    public void performSkillChecks(Hero hero) {
        for (Skill skill : this.plugin.getSkillManager().getSkills()) {
            if (skill instanceof OutsourcedSkill) {
                ((OutsourcedSkill)skill).tryLearningSkill(hero);
                continue;
            }
            if (!(skill instanceof PassiveSkill)) continue;
            ((PassiveSkill)skill).tryApplying(hero);
        }
    }

    public void removeHero(Hero hero) {
        if (hero != null) {
            if (hero.hasParty()) {
                HeroParty party = hero.getParty();
                HeroLeavePartyEvent event = new HeroLeavePartyEvent(hero, party, HeroLeavePartyEvent.LeavePartyReason.DISCONNECT);
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
                party.removeMember(hero);
                if (party.getMembers().size() == 0) {
                    this.plugin.getPartyManager().removeParty(party);
                }
            }
            if (hero.getDelayedSkill() != null) {
                this.delayedSkillQueue.remove(hero.getDelayedSkill());
                hero.setDelayedSkill(null);
            }
            this.heroes.remove(hero.getName().toLowerCase());
        }
    }

    public void saveHero(Hero hero, boolean now) {
        this.storage.saveHero(hero, now);
        Heroes.log(Level.INFO, "Saved hero: " + hero.getPlayer().getName());
    }

    public void saveHero(Player player, boolean now) {
        this.saveHero(this.getHero(player), now);
    }

    public void stopTimers() {
        this.plugin.getServer().getScheduler().cancelTasks((Plugin)this.plugin);
    }

    public void queueDelayedSkill(DelayedSkill dskill) {
        Hero hero = dskill.getHero();
        this.delayedSkillQueue.add(dskill);
        hero.setDelayedSkill(dskill);
    }

    public void cancelDelayedSkill(DelayedSkill dskill) {
        Hero hero = dskill.getHero();
        this.delayedSkillQueue.remove(dskill);
        hero.setDelayedSkill(null);
    }

    public void shutdown() {
        this.storage.shutdown();
        this.taskId.cancel();
    }

    @Deprecated
    public Storage getStorage() {
        return this.storage;
    }

    @Deprecated
    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public void removeMonster(LivingEntity lEntity) {
        if (!this.monsters.containsKey(lEntity.getUniqueId())) {
            return;
        }
        Monster monster = this.monsters.remove(lEntity.getUniqueId());
        monster.clearEffects();
    }

    private class DelayedSkillExecuter
    implements Runnable {
        private DelayedSkillExecuter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DelayedSkill dSkill;
            while ((dSkill = (DelayedSkill)CharacterManager.this.delayedSkillQueue.poll()) != null) {
                Hero hero = dSkill.getHero();
                try {
                    dSkill.getSkill().execute((CommandSender)dSkill.getPlayer(), dSkill.getIdentifier(), dSkill.getArgs());
                }
                catch (Exception e) {
                    Heroes.log(Level.SEVERE, "There was an error executing: " + dSkill.getSkill().getName() + " for " + hero.getPlayer().getName());
                    System.out.println(e);
                }
                finally {
                    hero.removeEffect(hero.getEffect("Casting"));
                    hero.setDelayedSkill(null);
                }
            }
        }
    }

    private class EntityReaper
    implements Runnable {
        private Set<UUID> toRemove = new HashSet<UUID>();

        private EntityReaper() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : CharacterManager.this.monsters.entrySet()) {
                if (((Monster)entry.getValue()).isEntityValid()) continue;
                this.toRemove.add((UUID)entry.getKey());
            }
            for (UUID uid : this.toRemove) {
                CharacterManager.this.monsters.remove(uid);
            }
            this.toRemove.clear();
        }
    }

    private class EntityQuickReaper
    implements Runnable {
        private Monster monster;

        public EntityQuickReaper(Monster m) {
            this.monster = m;
        }

        @Override
        public void run() {
            if (!this.monster.isEntityValid()) {
                CharacterManager.this.removeMonster(this.monster.getEntity());
            }
        }
    }
}

