/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.effects.CombatEffect;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.Expirable;
import com.herocraftonline.heroes.characters.effects.Periodic;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.LivingEntity;

public abstract class CharacterTemplate {
    private final Map<String, Effect> effects = new HashMap<String, Effect>();
    protected final Heroes plugin;
    protected final LivingEntity lEntity;
    protected Map<String, Double> healthMap = new ConcurrentHashMap<String, Double>();
    protected final String name;

    public CharacterTemplate(Heroes plugin, LivingEntity lEntity, String name) {
        this.plugin = plugin;
        this.lEntity = lEntity;
        this.name = name != null ? name : lEntity.getType().getName();
    }

    public String getName() {
        return this.name;
    }

    public Effect getEffect(String name) {
        return this.effects.get(name.toLowerCase());
    }

    public Set<Effect> getEffects() {
        return new HashSet<Effect>(this.effects.values());
    }

    public void addEffect(Effect effect) {
        if (this.hasEffect(effect.getName())) {
            this.removeEffect(this.getEffect(effect.getName()));
        }
        this.plugin.getEffectManager().manageEffect(this, effect);
        this.effects.put(effect.getName().toLowerCase(), effect);
        effect.apply(this);
    }

    public boolean isEntityValid() {
        return this.lEntity.isValid();
    }

    public boolean hasEffect(String name) {
        return this.effects.containsKey(name.toLowerCase());
    }

    public boolean hasEffectType(EffectType type) {
        for (Effect effect : this.effects.values()) {
            if (!effect.isType(type)) continue;
            return true;
        }
        return false;
    }

    public void removeEffect(Effect effect) {
        if (effect != null) {
            if (effect instanceof Expirable || effect instanceof Periodic) {
                this.plugin.getEffectManager().queueForRemoval(this, effect);
            }
            effect.remove(this);
            this.effects.remove(effect.getName().toLowerCase());
        }
    }

    public void manualRemoveEffect(Effect effect) {
        if (effect != null) {
            if (effect instanceof Expirable || effect instanceof Periodic) {
                this.plugin.getEffectManager().queueForRemoval(this, effect);
            }
            this.effects.remove(effect.getName().toLowerCase());
        }
    }

    public void clearEffects() {
        for (Effect effect : this.getEffects()) {
            if (effect instanceof CombatEffect) continue;
            this.removeEffect(effect);
        }
    }

    public LivingEntity getEntity() {
        return this.lEntity;
    }

    @Deprecated
    public boolean addMaxHealth(String key, int value) {
        return this.addMaxHealth(key, (double)value);
    }

    public boolean addMaxHealth(String key, double value) {
        if (this.lEntity.getHealth() < 1.0) {
            return false;
        }
        if (this.healthMap.containsKey(key)) {
            return false;
        }
        this.healthMap.put(key, value);
        this.lEntity.setMaxHealth(this.lEntity.getMaxHealth() + value);
        this.lEntity.setHealth(value + this.lEntity.getHealth());
        return true;
    }

    public boolean removeMaxHealth(String key) {
        Double old = this.healthMap.remove(key);
        double currentHealth = this.lEntity.getHealth();
        if (old != null) {
            double newHealth = this.lEntity.getHealth() - old;
            if (!(currentHealth <= 0.0) && newHealth < 1.0) {
                newHealth = 1.0;
            }
            if (this.lEntity.getHealth() != 0.0) {
                this.lEntity.setHealth(newHealth);
            }
            this.lEntity.setMaxHealth(this.lEntity.getMaxHealth() - old);
            return true;
        }
        return false;
    }

    public void clearHealthBonuses() {
        double current = this.lEntity.getHealth();
        Iterator<Map.Entry<String, Double>> iter = this.healthMap.entrySet().iterator();
        int minus = 0;
        while (iter.hasNext()) {
            Double val = iter.next().getValue();
            iter.remove();
            current -= val.doubleValue();
            minus = (int)((double)minus + val);
        }
        if (this.lEntity.getHealth() != 0.0) {
            this.lEntity.setHealth(current < 0.0 ? 0.0 : current);
        }
        this.lEntity.setMaxHealth(this.lEntity.getMaxHealth() - (double)minus);
    }

    public int hashCode() {
        return this.lEntity.getUniqueId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CharacterTemplate) {
            return ((CharacterTemplate)obj).lEntity.getUniqueId().equals(this.lEntity.getUniqueId());
        }
        return false;
    }
}

