/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.HeroDamageCause;
import com.herocraftonline.heroes.api.events.ExperienceChangeEvent;
import com.herocraftonline.heroes.api.events.HeroChangeLevelEvent;
import com.herocraftonline.heroes.api.events.ManaChangeEvent;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.effects.CombatEffect;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.skill.DelayedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public final class Hero
extends CharacterTemplate {
    public static final DecimalFormat decFormat = new DecimalFormat("#0.##");
    private Player player;
    private HeroClass heroClass;
    private HeroClass secondClass;
    private final AtomicInteger mana = new AtomicInteger(0);
    private HeroParty party = null;
    private final AtomicBoolean verbose = new AtomicBoolean(true);
    private HeroDamageCause lastDamageCause = null;
    private final Map<String, Double> experience = new ConcurrentHashMap<String, Double>();
    private final List<String> masteredClasses = new ArrayList<String>();
    private final Map<String, Long> cooldowns = new ConcurrentHashMap<String, Long>();
    private final Set<Monster> summons = new HashSet<Monster>();
    private final Map<Material, String[]> binds = new ConcurrentHashMap<Material, String[]>();
    private final Map<String, Boolean> suppressedSkills = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, ConfigurationSection> persistedSkillSettings = new ConcurrentHashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> skills = new HashMap<String, ConfigurationSection>();
    private boolean syncPrimary = true;
    private Integer tieredLevel;
    private final PermissionAttachment transientPerms;
    private DelayedSkill delayedSkill = null;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final CombatEffect combat;
    private final Map<String, Integer> manaMap = new ConcurrentHashMap<String, Integer>();

    public Hero(Heroes plugin, Player player, HeroClass heroClass, HeroClass secondClass) {
        super(plugin, (LivingEntity)player, player.getName());
        this.player = player;
        this.heroClass = heroClass;
        this.secondClass = secondClass;
        this.combat = new CombatEffect(plugin);
        this.addEffect(this.combat);
        this.transientPerms = player.addAttachment((Plugin)plugin);
    }

    public void resetMaxHP() {
        double maxHealth = this.resolveMaxHealth();
        this.player.setMaxHealth(maxHealth);
        this.player.setHealthScaled(true);
        if (Heroes.properties.oneHealthBar) {
            this.player.setHealthScale(20.0);
            return;
        }
        double scale = maxHealth / Heroes.properties.healthPerBar * 20.0;
        int roundedScale = (int)Math.round(scale);
        if (roundedScale % 2 != 0) {
            ++roundedScale;
        }
        this.player.setHealthScale((double)roundedScale);
    }

    public void heal(int amount) {
        this.heal(Math.ceil(amount));
    }

    public void heal(double amount) {
        double current = this.player.getHealth();
        double max = this.player.getMaxHealth();
        if (current <= 0.0) {
            return;
        }
        if (current + amount > max) {
            this.player.setHealth(max);
        } else {
            this.player.setHealth(current + amount);
        }
    }

    public void addPermission(String permission) {
        this.transientPerms.setPermission(permission, true);
    }

    public void addPermission(Permission permission) {
        this.transientPerms.setPermission(permission, true);
    }

    public void addSkill(String skill, ConfigurationSection section) {
        this.skills.put(skill.toLowerCase(), section);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExperienceType(HeroClass.ExperienceType type) {
        boolean val = false;
        try {
            this.rwl.readLock().lock();
            val = this.heroClass.hasExperiencetype(type) || this.secondClass != null && this.secondClass.hasExperiencetype(type);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGain(HeroClass.ExperienceType type) {
        if (type == HeroClass.ExperienceType.ADMIN) {
            return true;
        }
        boolean prim = false;
        boolean prof = false;
        try {
            this.rwl.readLock().lock();
            if (this.heroClass.hasExperiencetype(type)) {
                boolean bl = prim = !this.isMaster(this.heroClass) || Properties.padMaxLevel && this.getExperience(this.heroClass) < (double)(Properties.maxExp - 1);
            }
            if (this.secondClass != null && this.secondClass.hasExperiencetype(type)) {
                prof = !this.isMaster(this.secondClass) || Properties.padMaxLevel && this.getExperience(this.secondClass) < (double)(Properties.maxExp - 1);
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return prim || prof;
    }

    public void bind(Material material, String[] skillName) {
        if (material == Material.AIR || material == null) {
            return;
        }
        this.binds.put(material, skillName);
    }

    public void changeHeroClass(HeroClass heroClass, boolean secondary) {
        this.clearEffects();
        this.clearSummons();
        this.clearBinds();
        this.setHeroClass(heroClass, secondary);
        if (Heroes.properties.prefixClassName) {
            this.player.setDisplayName("[" + this.getHeroClass().getName() + "]" + this.player.getName());
        }
        this.plugin.getCharacterManager().performSkillChecks(this);
    }

    public void clearBinds() {
        this.binds.clear();
    }

    public void clearCooldowns() {
        this.cooldowns.clear();
    }

    public void clearExperience() {
        for (Map.Entry<String, Double> entry : this.experience.entrySet()) {
            entry.setValue(0.0);
        }
    }

    public void clearSummons() {
        for (Monster summon : this.summons) {
            summon.getEntity().remove();
        }
        this.summons.clear();
    }

    public void clearMasteries() {
        this.masteredClasses.clear();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hero other = (Hero)obj;
        return !(this.player == null ? other.player != null : !this.name.equals(other.name));
    }

    public void addExp(double expChange, HeroClass hc, Location loc) {
        double currentExp = this.getExperience(hc);
        double exp = currentExp + expChange;
        if (exp < 0.0) {
            exp = 0.0;
        }
        int currentLevel = this.getLevel(hc);
        this.setExperience(hc, exp);
        ExperienceChangeEvent expEvent = new ExperienceChangeEvent(this, hc, expChange, HeroClass.ExperienceType.ADMIN, loc);
        this.plugin.getServer().getPluginManager().callEvent((Event)expEvent);
        this.syncExperience();
        int newLevel = Properties.getLevel(exp);
        if (currentLevel != newLevel) {
            if (newLevel > hc.getMaxLevel()) {
                this.setExperience(hc, currentExp);
                this.syncExperience();
                return;
            }
            boolean isMastering = false;
            if (newLevel == hc.getMaxLevel()) {
                this.setExperience(hc, Properties.getTotalExp(hc.getMaxLevel()));
                if (!this.hasMastered(hc)) {
                    Messaging.broadcast(this.plugin, "$1 has become a master $2!", this.player.getName(), hc.getName());
                    isMastering = true;
                }
            }
            if (newLevel > currentLevel) {
                Messaging.send((CommandSender)this.player, "You gained a level! (Lvl $1 $2)", String.valueOf(newLevel), hc.getName());
                this.resetMaxHP();
                this.player.setHealth(this.player.getMaxHealth());
                if (this.player.getFoodLevel() < 20) {
                    this.player.setFoodLevel(20);
                }
                this.player.setExhaustion(0.0f);
                this.getTieredLevel(true);
            } else {
                this.resetMaxHP();
                Messaging.send((CommandSender)this.player, "You lost a level! (Lvl $1 $2)", String.valueOf(newLevel), hc.getName());
            }
            HeroChangeLevelEvent hLEvent = new HeroChangeLevelEvent(this, hc, currentLevel, newLevel, isMastering);
            this.plugin.getServer().getPluginManager().callEvent((Event)hLEvent);
        }
    }

    public void gainExp(double expChange, HeroClass.ExperienceType source, Location loc) {
        HeroClass[] classes;
        if (this.player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Properties prop = Heroes.properties;
        for (HeroClass hc : classes = new HeroClass[]{this.getHeroClass(), this.getSecondClass()}) {
            if (hc == null || source != HeroClass.ExperienceType.ADMIN && !hc.hasExperiencetype(source)) continue;
            double gainedExp = expChange;
            double exp = this.getExperience(hc);
            if (gainedExp > 0.0 && source != HeroClass.ExperienceType.ADMIN) {
                gainedExp *= hc.getExpModifier();
            } else if (!(source == HeroClass.ExperienceType.ADMIN || source == HeroClass.ExperienceType.ENCHANTING || !this.isMaster(hc) || prop.masteryLoss && prop.levelsViaExpLoss)) {
                return;
            }
            if (gainedExp > 0.0 && System.currentTimeMillis() < Heroes.properties.expiration) {
                gainedExp *= Heroes.properties.expBonus;
            }
            ExperienceChangeEvent expEvent = new ExperienceChangeEvent(this, hc, gainedExp, source, loc);
            this.plugin.getServer().getPluginManager().callEvent((Event)expEvent);
            if (expEvent.isCancelled()) {
                return;
            }
            gainedExp = expEvent.getExpChange();
            int currentLevel = Properties.getLevel(exp);
            int newLevel = Properties.getLevel(exp + gainedExp);
            if (this.isMaster(hc) && source != HeroClass.ExperienceType.ADMIN && source != HeroClass.ExperienceType.ENCHANTING && !prop.masteryLoss && !Properties.padMaxLevel) {
                gainedExp = 0.0;
                continue;
            }
            if (currentLevel > 1 && currentLevel > newLevel && !prop.levelsViaExpLoss && source != HeroClass.ExperienceType.ADMIN && source != HeroClass.ExperienceType.ENCHANTING) {
                gainedExp = (double)Properties.getTotalExp(currentLevel) - (exp - 1.0);
            } else if (this.isMaster(hc) && newLevel > currentLevel) {
                gainedExp = 0.0;
                continue;
            }
            exp += gainedExp;
            if (exp < 0.0) {
                gainedExp = -exp;
                exp = 0.0;
            } else if (exp > (double)Properties.maxExp) {
                exp = Properties.maxExp;
            }
            newLevel = Properties.getLevel(exp);
            this.setExperience(hc, exp);
            if (gainedExp != 0.0) {
                if (this.isVerbose() && gainedExp > 0.0) {
                    Messaging.send((CommandSender)this.player, "$1: Gained $2 Exp", hc.getName(), decFormat.format(gainedExp));
                } else if (this.isVerbose() && gainedExp < 0.0) {
                    Messaging.send((CommandSender)this.player, "$1: Lost $2 Exp", hc.getName(), decFormat.format(-gainedExp));
                }
                if (newLevel != currentLevel && newLevel <= hc.getMaxLevel()) {
                    HeroChangeLevelEvent hLEvent = new HeroChangeLevelEvent(this, hc, currentLevel, newLevel);
                    this.plugin.getServer().getPluginManager().callEvent((Event)hLEvent);
                    if (newLevel == hc.getMaxLevel()) {
                        Messaging.broadcast(this.plugin, "$1 has become a master $2!", this.player.getName(), hc.getName());
                    }
                    if (newLevel > currentLevel) {
                        this.resetMaxHP();
                        Messaging.send((CommandSender)this.player, "You gained a level! (Lvl $1 $2)", String.valueOf(newLevel), hc.getName());
                        if (this.player.getHealth() > 0.0) {
                            this.player.setHealth(this.player.getMaxHealth());
                            this.setMana(this.getMaxMana());
                            if (this.player.getFoodLevel() < 20) {
                                this.player.setFoodLevel(20);
                            }
                            this.player.setExhaustion(0.0f);
                        }
                        this.getTieredLevel(true);
                    } else {
                        this.resetMaxHP();
                        Messaging.send((CommandSender)this.player, "You lost a level! (Lvl $1 $2)", String.valueOf(newLevel), hc.getName());
                    }
                }
            }
            if (newLevel == currentLevel) continue;
            this.plugin.getCharacterManager().saveHero(this, false);
        }
        this.syncExperience();
    }

    public double currentXPToNextLevel(HeroClass hc) {
        return this.getExperience(hc) - (double)Properties.getTotalExp(this.getLevel(hc));
    }

    protected double calculateXPLoss(double multiplier, HeroClass hc) {
        double expForNext = Properties.getExp(this.getLevel(hc) + 1);
        double currentPercent = this.currentXPToNextLevel(hc) / expForNext;
        if (currentPercent >= multiplier) {
            return expForNext * multiplier;
        }
        double amt = expForNext * currentPercent;
        multiplier -= currentPercent;
        int i = 0;
        while (this.getLevel(hc) - i > 1) {
            if (1.0 >= multiplier) {
                return amt + (double)Properties.getExp(this.getLevel(hc) - i) * multiplier;
            }
            amt += (double)Properties.getExp(this.getLevel(hc) - i);
            multiplier -= 1.0;
            ++i;
        }
        return amt;
    }

    public void loseExpFromDeath(double multiplier, boolean pvp) {
        if (this.player.getGameMode() == GameMode.CREATIVE || multiplier <= 0.0) {
            return;
        }
        Properties prop = Heroes.properties;
        HeroClass[] classes = new HeroClass[]{this.getHeroClass(), this.getSecondClass()};
        if (prop.resetOnDeath) {
            this.clearExperience();
            this.setHeroClass(null, true);
            this.setHeroClass(this.plugin.getClassManager().getDefaultClass(), false);
            Messaging.send((CommandSender)this.player, "You've lost all your experience and have been reset to $1 for dying!", this.plugin.getClassManager().getDefaultClass().getName());
            this.plugin.getCharacterManager().saveHero(this, false);
            this.syncExperience();
            return;
        }
        for (HeroClass hc : classes) {
            double newExp;
            if (hc == null) continue;
            double mult = multiplier;
            if (pvp && hc.getPvpExpLoss() != -1.0) {
                mult = hc.getPvpExpLoss();
            } else if (!pvp && hc.getExpLoss() != -1.0) {
                mult = hc.getExpLoss();
            }
            int currentLvl = this.getLevel(hc);
            double currentExp = this.getExperience(hc);
            double currentLvlExp = Properties.getTotalExp(currentLvl);
            double gainedExp = -this.calculateXPLoss(mult, hc);
            if (gainedExp + currentExp < currentLvlExp && !prop.levelsViaExpLoss) {
                gainedExp = -(currentExp - currentLvlExp);
            }
            ExperienceChangeEvent expEvent = new ExperienceChangeEvent(this, hc, gainedExp, HeroClass.ExperienceType.DEATH, this.player.getLocation());
            this.plugin.getServer().getPluginManager().callEvent((Event)expEvent);
            if (expEvent.isCancelled()) {
                return;
            }
            gainedExp = expEvent.getExpChange();
            int newLevel = Properties.getLevel(currentExp + gainedExp);
            if (this.isMaster(hc) && !prop.masteryLoss) continue;
            if (currentLvl > newLevel && !prop.levelsViaExpLoss) {
                gainedExp = currentLvlExp - (currentExp - 1.0);
            }
            if ((newExp = currentExp + gainedExp) < 0.0) {
                gainedExp = -currentExp;
                newExp = 0.0;
            }
            newLevel = Properties.getLevel(newExp);
            this.setExperience(hc, newExp);
            if (gainedExp == 0.0) continue;
            if (this.isVerbose() && gainedExp < 0.0) {
                Messaging.send((CommandSender)this.player, "$1: Lost $2 Exp", hc.getName(), decFormat.format(-gainedExp));
            }
            if (newLevel == currentLvl) continue;
            HeroChangeLevelEvent hLEvent = new HeroChangeLevelEvent(this, hc, currentLvl, newLevel);
            this.plugin.getServer().getPluginManager().callEvent((Event)hLEvent);
            if (newLevel >= hc.getMaxLevel()) {
                this.setExperience(hc, Properties.getTotalExp(hc.getMaxLevel()));
                Messaging.broadcast(this.plugin, "$1 has become a master $2!", this.player.getName(), hc.getName());
            }
            this.resetMaxHP();
            Messaging.send((CommandSender)this.player, "You lost a level! (Lvl $1 $2)", String.valueOf(newLevel), hc.getName());
        }
        this.plugin.getCharacterManager().saveHero(this, false);
        this.syncExperience();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String[] getBind(Material mat) {
        return this.binds.get(mat);
    }

    public Map<Material, String[]> getBinds() {
        return Collections.unmodifiableMap(this.binds);
    }

    public Long getCooldown(String name) {
        return this.cooldowns.get(name.toLowerCase());
    }

    public Map<String, Long> getCooldowns() {
        return Collections.unmodifiableMap(this.cooldowns);
    }

    public double getExperience(HeroClass heroClass) {
        if (heroClass == null) {
            return 0.0;
        }
        Double exp = this.experience.get(heroClass.getName());
        return exp == null ? 0.0 : exp;
    }

    public Map<String, Double> getExperienceMap() {
        return Collections.unmodifiableMap(this.experience);
    }

    public HeroClass getHeroClass() {
        this.rwl.readLock().lock();
        HeroClass hc = this.heroClass;
        this.rwl.readLock().unlock();
        return hc;
    }

    public HeroDamageCause getLastDamageCause() {
        return this.lastDamageCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLevel() {
        int second;
        int primary;
        try {
            this.rwl.readLock().lock();
            primary = this.getLevel(this.heroClass);
            second = 0;
            if (this.secondClass != null) {
                second = this.getLevel(this.secondClass);
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return primary > second ? primary : second;
    }

    public int getSkillLevel(Skill skill) {
        HeroClass secondClass;
        int level = -1;
        int secondLevel = -1;
        HeroClass heroClass = this.getHeroClass();
        if (heroClass.hasSkill(skill.getName())) {
            int requiredLevel = SkillConfigManager.getSetting(heroClass, skill, SkillSetting.LEVEL.node(), 1);
            level = this.getLevel(heroClass);
            if (level < requiredLevel) {
                level = -1;
            }
        }
        if ((secondClass = this.getSecondClass()) != null && secondClass.hasSkill(skill.getName())) {
            int requiredLevel = SkillConfigManager.getSetting(secondClass, skill, SkillSetting.LEVEL.node(), 1);
            secondLevel = this.getLevel(secondClass);
            if (secondLevel < requiredLevel) {
                secondLevel = -1;
            }
        }
        return secondLevel > level ? secondLevel : level;
    }

    public int getLevel(HeroClass heroClass) {
        return Properties.getLevel(this.getExperience(heroClass));
    }

    public int getTieredLevel(boolean recache) {
        int sc;
        int hc;
        if (this.tieredLevel != null && !recache) {
            return this.tieredLevel;
        }
        HeroClass heroClass = this.getHeroClass();
        HeroClass secondClass = this.getSecondClass();
        this.tieredLevel = secondClass == null ? Integer.valueOf(this.getTieredLevel(heroClass)) : Integer.valueOf((hc = this.getTieredLevel(heroClass)) > (sc = this.getTieredLevel(secondClass)) ? hc : sc);
        return this.tieredLevel;
    }

    public int getTieredLevel(HeroClass heroClass) {
        if (heroClass.hasNoParents()) {
            return this.getLevel(heroClass);
        }
        HashSet<HeroClass> classes = new HashSet<HeroClass>();
        for (HeroClass hClass : heroClass.getParents()) {
            if (!this.isMaster(hClass)) continue;
            classes.addAll(this.getTieredLevel(hClass, new HashSet<HeroClass>(classes)));
            classes.add(hClass);
        }
        int level = this.getLevel(heroClass);
        for (HeroClass hClass : classes) {
            if (hClass.getTier() == 0) continue;
            level += this.getLevel(hClass);
        }
        return level;
    }

    private Set<HeroClass> getTieredLevel(HeroClass heroClass, Set<HeroClass> classes) {
        for (HeroClass hClass : heroClass.getParents()) {
            if (!this.isMaster(hClass)) continue;
            classes.addAll(this.getTieredLevel(hClass, new HashSet<HeroClass>(classes)));
            classes.add(hClass);
        }
        return classes;
    }

    public HeroClass getSecondClass() {
        this.rwl.readLock().lock();
        HeroClass sc = this.secondClass;
        this.rwl.readLock().unlock();
        return sc;
    }

    public int getMana() {
        return this.mana.get();
    }

    public double resolveMaxHealth() {
        HeroClass heroClass = this.getHeroClass();
        int level = Properties.getLevel(this.getExperience(heroClass));
        double primaryHp = (double)heroClass.getBaseMaxHealth() + (double)(level - 1) * heroClass.getMaxHealthPerLevel();
        int secondHp = 0;
        HeroClass secondClass = this.getSecondClass();
        if (secondClass != null) {
            level = Properties.getLevel(this.getExperience(secondClass));
            secondHp = secondClass.getBaseMaxHealth() + (int)((double)(level - 1) * secondClass.getMaxHealthPerLevel());
        }
        double selected = primaryHp > (double)secondHp ? primaryHp : (double)secondHp;
        for (Double add : this.healthMap.values()) {
            selected += add.doubleValue();
        }
        return selected;
    }

    public boolean addMaxMana(String key, int value) {
        if (this.manaMap.containsKey(key)) {
            return false;
        }
        this.manaMap.put(key, value);
        this.setMana(this.getMana() + value);
        return true;
    }

    public boolean removeMaxMana(String key) {
        Integer val = this.manaMap.remove(key);
        if (val == null) {
            return false;
        }
        this.setMana(this.getMana() - val);
        return true;
    }

    public void clearMaxMana() {
        int current = this.getMana();
        Iterator<Map.Entry<String, Integer>> iter = this.manaMap.entrySet().iterator();
        while (iter.hasNext()) {
            Integer val = iter.next().getValue();
            iter.remove();
            current -= val.intValue();
        }
        this.setMana(current);
    }

    public int getMaxMana() {
        HeroClass heroClass = this.getHeroClass();
        int level = Properties.getLevel(this.getExperience(heroClass));
        double primaryMana = (double)heroClass.getBaseMaxMana() + (double)(level - 1) * heroClass.getMaxManaPerLevel();
        double secondMana = 0.0;
        HeroClass secondClass = this.getSecondClass();
        if (secondClass != null) {
            level = Properties.getLevel(this.getExperience(secondClass));
            secondMana = (double)secondClass.getBaseMaxMana() + (double)(level - 1) * secondClass.getMaxManaPerLevel();
        }
        int value = (int)(primaryMana > secondMana ? primaryMana : secondMana);
        for (Integer add : this.manaMap.values()) {
            value += add.intValue();
        }
        return value;
    }

    public int getManaRegen() {
        HeroClass heroClass = this.getHeroClass();
        int level = Properties.getLevel(this.getExperience(heroClass));
        double primaryMana = heroClass.getManaRegen() + (double)(level - 1) * heroClass.getManaRegenPerLevel();
        double secondMana = 0.0;
        HeroClass secondClass = this.getSecondClass();
        if (secondClass != null) {
            level = Properties.getLevel(this.getExperience(secondClass));
            secondMana = secondClass.getManaRegen() + (double)(level - 1) * secondClass.getManaRegenPerLevel();
        }
        return (int)(primaryMana > secondMana ? primaryMana : secondMana);
    }

    public HeroParty getParty() {
        return this.party;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Map<String, ConfigurationSection> getSkills() {
        return new HashMap<String, ConfigurationSection>(this.skills);
    }

    public Map<String, ConfigurationSection> getSkillSettings() {
        return Collections.unmodifiableMap(this.persistedSkillSettings);
    }

    public ConfigurationSection getSkillSettings(Skill skill) {
        return skill == null ? null : this.getSkillSettings(skill.getName());
    }

    public ConfigurationSection getSkillSettings(String skillName) {
        HeroClass secondClass = this.getSecondClass();
        if (!(this.getHeroClass().hasSkill(skillName) || secondClass != null && secondClass.hasSkill(skillName))) {
            return null;
        }
        return this.persistedSkillSettings.get(skillName.toLowerCase());
    }

    public Set<Monster> getSummons() {
        return this.summons;
    }

    public boolean isOwnedSummon(LivingEntity possible) {
        for (Monster m : this.summons) {
            if (!m.getEntity().equals(possible)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getSuppressedSkills() {
        return this.suppressedSkills.keySet();
    }

    public boolean hasBind(Material mat) {
        return this.binds.containsKey(mat);
    }

    @Override
    public int hashCode() {
        return this.player == null ? 0 : this.name.hashCode();
    }

    public boolean hasParty() {
        return this.party != null;
    }

    public boolean canUseSkill(Skill skill) {
        if (this.canPrimaryUseSkill(skill)) {
            return true;
        }
        if (this.canSecondUseSkill(skill)) {
            return true;
        }
        HeroClass secondClass = this.getSecondClass();
        ConfigurationSection section = this.skills.get(skill.getName().toLowerCase());
        if (section != null) {
            int level = section.getInt(SkillSetting.LEVEL.node(), 1);
            if (this.getLevel(this.getHeroClass()) >= level || secondClass != null && this.getLevel(secondClass) >= level) {
                return true;
            }
        }
        return false;
    }

    public boolean canPrimaryUseSkill(Skill skill) {
        HeroClass heroClass = this.getHeroClass();
        if (heroClass.hasSkill(skill.getName())) {
            int level = SkillConfigManager.getSetting(heroClass, skill, SkillSetting.LEVEL.node(), 1);
            if (this.getLevel(heroClass) >= level) {
                return true;
            }
        }
        return false;
    }

    public boolean canSecondUseSkill(Skill skill) {
        HeroClass secondClass = this.getSecondClass();
        if (secondClass != null && secondClass.hasSkill(skill.getName())) {
            int level = SkillConfigManager.getSetting(secondClass, skill, SkillSetting.LEVEL.node(), 1);
            if (this.getLevel(secondClass) >= level) {
                return true;
            }
        }
        return false;
    }

    public boolean canUseSkill(String name) {
        return this.canUseSkill(this.plugin.getSkillManager().getSkill(name));
    }

    public boolean hasAccessToSkill(Skill skill) {
        return this.hasAccessToSkill(skill.getName());
    }

    public boolean hasAccessToSkill(String name) {
        HeroClass secondClass = this.getSecondClass();
        return this.getHeroClass().hasSkill(name) || secondClass != null && secondClass.hasSkill(name) || this.skills.containsKey(name.toLowerCase());
    }

    public boolean isMaster(HeroClass heroClass) {
        return this.getLevel(heroClass) >= heroClass.getMaxLevel();
    }

    public void setMastered(HeroClass heroClass) {
        this.masteredClasses.add(heroClass.getName());
    }

    public List<String> getMasteredClasses() {
        return Collections.unmodifiableList(this.masteredClasses);
    }

    public boolean hasMastered(HeroClass heroClass) {
        return this.masteredClasses.contains(heroClass.getName());
    }

    public boolean isSuppressing(Skill skill) {
        return this.suppressedSkills.containsKey(skill.getName());
    }

    public boolean isVerbose() {
        return this.verbose.get();
    }

    public DelayedSkill getDelayedSkill() {
        return this.delayedSkill;
    }

    public void setDelayedSkill(DelayedSkill wSkill) {
        this.delayedSkill = wSkill;
    }

    public void cancelDelayedSkill() {
        if (this.delayedSkill == null) {
            return;
        }
        Skill skill = this.delayedSkill.getSkill();
        this.delayedSkill = null;
        this.removeEffect(this.getEffect("Casting"));
        skill.broadcast(this.player.getLocation(), "\u00a77[\u00a72Skill\u00a77] $1 stopped using $2!", this.player.getDisplayName(), skill.getName());
    }

    public void removeCooldown(String name) {
        this.cooldowns.remove(name.toLowerCase());
    }

    public void removePermission(String permission) {
        this.transientPerms.unsetPermission(permission);
        this.player.recalculatePermissions();
    }

    public void removePermission(Permission permission) {
        this.transientPerms.unsetPermission(permission);
        this.player.recalculatePermissions();
    }

    public void removeSkill(String skill) {
        this.skills.remove(skill.toLowerCase());
    }

    public void setCooldown(String name, long cooldown) {
        this.cooldowns.put(name.toLowerCase(), cooldown);
    }

    public void setExperience(HeroClass heroClass, double experience) {
        this.experience.put(heroClass.getName(), experience);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeroClass(HeroClass heroClass, boolean secondary) {
        try {
            this.rwl.writeLock().lock();
            if (secondary) {
                this.secondClass = heroClass;
            } else {
                this.heroClass = heroClass;
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        double currentHP = this.player.getHealth();
        double maxHP = this.player.getMaxHealth();
        this.resetMaxHP();
        double ratio = currentHP / maxHP;
        if (ratio != 0.0) {
            this.player.setHealth(ratio * this.player.getMaxHealth());
        }
        this.getTieredLevel(true);
        this.checkInventory();
    }

    public void setLastDamageCause(HeroDamageCause lastDamageCause) {
        this.lastDamageCause = lastDamageCause;
    }

    public void setMana(int mana) {
        int maxMana = this.getMaxMana();
        if (mana > maxMana) {
            mana = maxMana;
        } else if (mana < 0) {
            mana = 0;
        }
        if (this.mana.get() != mana) {
            ManaChangeEvent event = new ManaChangeEvent(this, this.mana.get(), mana);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.mana.set(event.getFinalMana());
        } else {
            this.mana.getAndSet(mana);
        }
    }

    public void setParty(HeroParty party) {
        this.party = party;
    }

    public void setSkillSetting(Skill skill, String node, Object val) {
        this.setSkillSetting(skill.getName(), node, val);
    }

    public void setSkillSetting(String skill, String node, Object val) {
        ConfigurationSection section = this.persistedSkillSettings.get(skill.toLowerCase());
        if (section == null) {
            section = new MemoryConfiguration();
            this.persistedSkillSettings.put(skill.toLowerCase(), section);
        }
        section.set(node, val);
    }

    public void setSuppressed(Skill skill, boolean suppressed) {
        if (suppressed) {
            this.suppressedSkills.put(skill.getName(), true);
        } else {
            this.suppressedSkills.remove(skill.getName());
        }
    }

    public void setSuppressedSkills(Collection<String> suppressedSkills) {
        for (String s : suppressedSkills) {
            this.suppressedSkills.put(s, true);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose.getAndSet(verbose);
    }

    public HeroClass getEnchantingClass() {
        HeroClass heroClass = this.getHeroClass();
        HeroClass secondClass = this.getSecondClass();
        int level = 0;
        if (heroClass.hasExperiencetype(HeroClass.ExperienceType.ENCHANTING)) {
            level = this.getLevel(heroClass);
        }
        if (secondClass != null && secondClass.hasExperiencetype(HeroClass.ExperienceType.ENCHANTING) && this.getLevel(secondClass) > level) {
            return secondClass;
        }
        return level != 0 ? heroClass : null;
    }

    public void syncExperience() {
        HeroClass secondClass = this.getSecondClass();
        if (secondClass != null && !this.syncPrimary) {
            this.syncExperience(secondClass);
        } else {
            this.syncExperience(this.getHeroClass());
        }
    }

    public void syncExperience(HeroClass hc) {
        int level = this.getLevel(hc);
        int currentLevelXP = Properties.getTotalExp(level);
        double maxLevelXP = Properties.getTotalExp(level + 1) - currentLevelXP;
        double currentXP = this.getExperience(hc) - (double)currentLevelXP;
        float syncedPercent = (float)(currentXP / maxLevelXP);
        this.player.setTotalExperience(Util.getMCExperience(level));
        this.player.setExp(syncedPercent);
        this.player.setLevel(level);
    }

    public void unbind(Material material) {
        this.binds.remove(material);
    }

    public void checkInventory() {
        if (this.player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        int removedCount = this.checkArmorSlots();
        for (int i = 0; i < 9; ++i) {
            if (this.canEquipItem(i)) continue;
            ++removedCount;
        }
        if (removedCount > 0) {
            Messaging.send((CommandSender)this.player, "$1 have been removed from your inventory due to class restrictions.", removedCount + " Items");
            Util.syncInventory(this.player, this.plugin);
        }
    }

    public int checkArmorSlots() {
        Material item;
        PlayerInventory inv = this.player.getInventory();
        int removedCount = 0;
        HeroClass heroClass = this.getHeroClass();
        HeroClass secondClass = this.getSecondClass();
        int hatsLevel = Heroes.properties.hatsLevel;
        if (!(inv.getHelmet() == null || (item = inv.getHelmet().getType()) == Material.AIR || !Util.isArmor(item) && Heroes.properties.allowHats && (!Heroes.properties.allowHats || this.getLevel(heroClass) >= hatsLevel || secondClass != null && this.getLevel(secondClass) >= hatsLevel) || heroClass.isAllowedArmor(item) || secondClass != null && secondClass.isAllowedArmor(item))) {
            Util.moveItem(this, -1, inv.getHelmet());
            inv.setHelmet(null);
            ++removedCount;
        }
        if (!(inv.getChestplate() == null || (item = inv.getChestplate().getType()) == Material.AIR || heroClass.isAllowedArmor(item) || secondClass != null && secondClass.isAllowedArmor(item))) {
            Util.moveItem(this, -1, inv.getChestplate());
            inv.setChestplate(null);
            ++removedCount;
        }
        if (!(inv.getLeggings() == null || (item = inv.getLeggings().getType()) == Material.AIR || heroClass.isAllowedArmor(item) || secondClass != null && secondClass.isAllowedArmor(item))) {
            Util.moveItem(this, -1, inv.getLeggings());
            inv.setLeggings(null);
            ++removedCount;
        }
        if (!(inv.getBoots() == null || (item = inv.getBoots().getType()) == Material.AIR || heroClass.isAllowedArmor(item) || secondClass != null && secondClass.isAllowedArmor(item))) {
            Util.moveItem(this, -1, inv.getBoots());
            inv.setBoots(null);
            ++removedCount;
        }
        return removedCount;
    }

    public boolean canEquipItem(int slot) {
        ItemStack itemStack = this.player.getInventory().getItem(slot);
        if (itemStack == null) {
            return true;
        }
        HeroClass secondClass = this.getSecondClass();
        Material itemType = itemStack.getType();
        if (!Util.isWeapon(itemType)) {
            return true;
        }
        if (this.getHeroClass().isAllowedWeapon(itemType) || secondClass != null && secondClass.isAllowedWeapon(itemType)) {
            return true;
        }
        Util.moveItem(this, slot, itemStack);
        return false;
    }

    public boolean canCraft(Object o) {
        HeroClass heroClass;
        int level;
        if (o instanceof ItemStack && ((ItemStack)o).getType() == Material.MAP) {
            o = Material.MAP;
        }
        if ((level = (heroClass = this.getHeroClass()).getCraftLevel(o)) != -1 && level <= this.getLevel(heroClass)) {
            return true;
        }
        HeroClass secondClass = this.getSecondClass();
        return secondClass != null && (level = secondClass.getCraftLevel(o)) != -1 && level <= this.getLevel(secondClass);
    }

    public boolean isSyncPrimary() {
        return this.syncPrimary;
    }

    public void setSyncPrimary(boolean syncPrimary) {
        this.syncPrimary = syncPrimary || this.getSecondClass() == null;
        this.syncExperience();
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void resetCombatEffect() {
        this.addEffect(this.combat);
    }

    public boolean isInCombat() {
        return this.combat.isInCombat();
    }

    public void recheckCombat() {
        if (this.combat.getTimeLeft() == 0L) {
            this.combat.clearCombatants();
        } else {
            ArrayList<LivingEntity> combatants = new ArrayList<LivingEntity>(this.combat.getCombatants().keySet());
            for (LivingEntity le : combatants) {
                if (!le.isDead() && le.isValid()) continue;
                this.combat.leaveCombatWith(this, le, CombatEffect.LeaveCombatReason.ERROR);
            }
        }
    }

    public boolean isInCombatWith(LivingEntity target) {
        return this.combat.isInCombatWith(target);
    }

    public boolean enterCombatWith(LivingEntity entity, CombatEffect.CombatReason reason) {
        boolean start = !this.combat.isInCombat();
        this.combat.enterCombatWith(entity, reason);
        if (start) {
            Messaging.send((CommandSender)this.getPlayer(), "You have entered combat!", new Object[0]);
        }
        return start;
    }

    public void refreshCombat() {
        this.combat.reset();
    }

    public CombatEffect getCombatEffect() {
        return this.combat;
    }

    public boolean leaveCombatWith(LivingEntity entity, CombatEffect.LeaveCombatReason reason) {
        this.combat.leaveCombatWith(this, entity, reason);
        return !this.combat.isInCombat();
    }

    public void leaveCombat(CombatEffect.LeaveCombatReason reason) {
        switch (reason) {
            case LOGOUT: {
                this.combat.leaveCombatFromLogout(this);
                break;
            }
            case DEATH: {
                this.combat.leaveCombatFromDeath(this);
                break;
            }
            case SUICIDE: {
                this.combat.leaveCombatFromSuicide(this);
                break;
            }
        }
    }

    public Map<LivingEntity, CombatEffect.CombatReason> getCombatants() {
        return this.combat.getCombatants();
    }

    public Location getViewingLocation(double distance) {
        Location loc = this.getPlayer().getLocation();
        loc.add(loc.getDirection().normalize().multiply(distance));
        return loc;
    }
}

