/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.api.events.HeroRegainManaEvent;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.util.Messaging;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

class ManaUpdater
implements Runnable {
    private final CharacterManager manager;
    private final long updateInterval;
    private long lastUpdate = 0L;

    ManaUpdater(CharacterManager manager, long updateInterval) {
        this.manager = manager;
        this.updateInterval = updateInterval;
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        if (time < this.lastUpdate + this.updateInterval) {
            return;
        }
        this.lastUpdate = time;
        Collection<Hero> heroes = this.manager.getHeroes();
        for (Hero hero : heroes) {
            if (hero == null || !hero.getPlayer().isOnline()) continue;
            int regen = hero.getManaRegen();
            int mana = hero.getMana();
            if (mana >= hero.getMaxMana()) continue;
            HeroRegainManaEvent hrmEvent = new HeroRegainManaEvent(hero, regen, null);
            Bukkit.getServer().getPluginManager().callEvent((Event)hrmEvent);
            if (hrmEvent.isCancelled()) continue;
            hero.setMana(mana + hrmEvent.getAmount());
            if (!hero.isVerbose()) continue;
            Messaging.send((CommandSender)hero.getPlayer(), ChatColor.BLUE + "MANA " + Messaging.createManaBar(hero.getMana(), hero.getMaxMana()), new Object[0]);
        }
    }
}

