/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.util.Util;
import java.util.UUID;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Slime;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.MetadataValue;

public class Monster
extends CharacterTemplate {
    public static final String SPAWNREASON_META_KEY = "Heroes: Spawn Reason";
    private double damage = 0.0;
    private int experience = -1;
    private CreatureSpawnEvent.SpawnReason spawnReason = null;

    public Monster(Heroes plugin, LivingEntity lEntity) {
        this(plugin, lEntity, null);
    }

    protected Monster(Heroes plugin, LivingEntity lEntity, String name) {
        super(plugin, lEntity, name);
        double damage;
        this.damage = damage = plugin.getDamageManager().getEntityDamage(lEntity.getType());
        if (lEntity instanceof Slime) {
            Slime slime = (Slime)lEntity;
            switch (slime.getSize()) {
                case 1: {
                    if (slime instanceof MagmaCube) {
                        this.damage -= damage / 3.0;
                    } else {
                        this.damage = 0.0;
                        break;
                    }
                }
                case 2: {
                    this.damage -= damage / 3.0;
                }
            }
        }
        Monster.applyHealthChanges(lEntity);
        this.spawnReason = lEntity.hasMetadata(SPAWNREASON_META_KEY) ? (CreatureSpawnEvent.SpawnReason)((MetadataValue)lEntity.getMetadata(SPAWNREASON_META_KEY).get(0)).value() : CreatureSpawnEvent.SpawnReason.DEFAULT;
    }

    public static void applyHealthChanges(LivingEntity lEntity) {
        double defaultMaxHealth = Math.floor(Util.getDefaultMaxHealth(lEntity));
        if (Math.floor(lEntity.getMaxHealth()) == defaultMaxHealth || defaultMaxHealth == 0.0) {
            if (lEntity.getHealth() == lEntity.getMaxHealth()) {
                double max = Heroes.getInstance().getDamageManager().getEntityMaxHealth(lEntity);
                lEntity.setMaxHealth(max);
                lEntity.setHealth(max);
            } else {
                double ratio = lEntity.getHealth() / lEntity.getMaxHealth();
                double max = Heroes.getInstance().getDamageManager().getEntityMaxHealth(lEntity);
                double health = max * ratio;
                lEntity.setMaxHealth(max);
                lEntity.setHealth(health);
            }
        }
    }

    @Deprecated
    public boolean setMaxHealth(int maxHealth) {
        return this.setMaxHealth((double)maxHealth);
    }

    public boolean setMaxHealth(double maxHealth) {
        if (this.lEntity.getHealth() != this.lEntity.getMaxHealth() || maxHealth <= 0.0) {
            return false;
        }
        this.lEntity.setMaxHealth(maxHealth);
        this.lEntity.setHealth(maxHealth);
        return true;
    }

    public double getDamage() {
        return this.damage;
    }

    @Deprecated
    public void setDamage(int damage) {
        this.setDamage((double)damage);
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    @Override
    public void clearEffects() {
        for (Effect effect : this.getEffects()) {
            this.removeEffect(effect);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LivingEntity) {
            return this.lEntity.equals(obj);
        }
        if (obj instanceof UUID) {
            return this.lEntity.getUniqueId().equals(obj);
        }
        if (obj instanceof Monster) {
            return this.lEntity.getUniqueId().equals(((Monster)obj).lEntity.getUniqueId());
        }
        return false;
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setSpawnReason(CreatureSpawnEvent.SpawnReason reason) {
        this.spawnReason = reason;
    }

    public CreatureSpawnEvent.SpawnReason getSpawnReason() {
        return this.spawnReason;
    }
}

