/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.classes;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.util.RecipeGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.Material;

public final class HeroClass
implements Comparable<HeroClass> {
    private final String name;
    private String description;
    private final Set<HeroClass> strongParents = new HashSet<HeroClass>();
    private final Set<HeroClass> weakParents = new HashSet<HeroClass>();
    private Set<HeroClass> specializations = new LinkedHashSet<HeroClass>();
    private final Set<Material> allowedArmor = EnumSet.noneOf(Material.class);
    private final Set<Material> allowedWeapons = EnumSet.noneOf(Material.class);
    private Set<ExperienceType> experienceSources = EnumSet.noneOf(ExperienceType.class);
    private boolean primary = true;
    private boolean secondary = false;
    private int tier = 1;
    private final Map<Material, Double> itemDamage = new EnumMap<Material, Double>(Material.class);
    private final Map<Material, Double> itemDamageLevel = new EnumMap<Material, Double>(Material.class);
    private final Map<CharacterDamageManager.ProjectileType, Double> projectileDamage = new EnumMap<CharacterDamageManager.ProjectileType, Double>(CharacterDamageManager.ProjectileType.class);
    private final Map<CharacterDamageManager.ProjectileType, Double> projDamageLevel = new EnumMap<CharacterDamageManager.ProjectileType, Double>(CharacterDamageManager.ProjectileType.class);
    private final Set<String> skills = new LinkedHashSet<String>();
    private final List<RecipeGroup> recipes = new ArrayList<RecipeGroup>();
    private double cost;
    private double expModifier;
    private double expLoss;
    private double pvpExpLoss;
    private int maxLevel;
    private int baseMaxHealth;
    private int baseMaxMana;
    private double maxHealthPerLevel;
    private double maxManaPerLevel;
    private double manaRegen;
    private double manaRegenPerLevel;
    private boolean wildcard = true;
    private final Heroes plugin;

    HeroClass(String name, Heroes plugin) {
        this.name = name;
        this.plugin = plugin;
        this.description = "";
        this.expModifier = 1.0;
        this.baseMaxHealth = 20;
        this.maxHealthPerLevel = 0.0;
        this.maxLevel = 1;
        this.cost = 0.0;
    }

    protected void addAllowedArmor(Material armor) {
        this.allowedArmor.add(armor);
    }

    protected void addAllowedWeapon(Material weapon) {
        this.allowedWeapons.add(weapon);
    }

    protected void addSkill(String name) {
        this.skills.add(name.toLowerCase());
    }

    public void addSpecialization(HeroClass heroClass) {
        this.specializations.add(heroClass);
    }

    public void addStrongParent(HeroClass parent) throws CircularParentException {
        if (parent.equals(this)) {
            throw new CircularParentException();
        }
        List<HeroClass> parents = parent.getParents();
        for (HeroClass hc : parents) {
            if (hc.equals(this)) {
                throw new CircularParentException();
            }
            hc.checkCircular(this);
        }
        this.strongParents.add(parent);
    }

    public void addWeakParent(HeroClass parent) throws CircularParentException {
        if (parent.equals(this)) {
            throw new CircularParentException();
        }
        List<HeroClass> parents = parent.getParents();
        for (HeroClass hc : parents) {
            if (hc.equals(this)) {
                throw new CircularParentException();
            }
            hc.checkCircular(this);
        }
        this.weakParents.add(parent);
    }

    private void checkCircular(HeroClass heroClass) throws CircularParentException {
        List<HeroClass> parents = this.getParents();
        for (HeroClass hc : parents) {
            if (hc.equals(heroClass)) {
                throw new CircularParentException();
            }
            hc.checkCircular(heroClass);
        }
    }

    public Set<HeroClass> getAllParents() {
        HashSet<HeroClass> classes = new HashSet<HeroClass>();
        for (HeroClass hClass : this.getParents()) {
            classes.add(hClass);
            classes.addAll(hClass.getAllParents(new HashSet<HeroClass>(classes)));
        }
        return classes;
    }

    private Set<HeroClass> getAllParents(Set<HeroClass> parents) {
        for (HeroClass hClass : this.getParents()) {
            parents.addAll(hClass.getAllParents(new HashSet<HeroClass>(parents)));
        }
        return parents;
    }

    public int getCraftLevel(Object obj) {
        int level = -1;
        for (RecipeGroup rg : this.recipes) {
            Boolean b = rg.get(obj);
            if (b == null) continue;
            if (!b.booleanValue()) {
                return -1;
            }
            if (level == -1) {
                level = rg.level;
                continue;
            }
            if (rg.level >= level) continue;
            level = rg.level;
        }
        return level;
    }

    public boolean isDefault() {
        return this.plugin.getClassManager().getDefaultClass().equals(this);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    protected void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean isSecondary() {
        return this.secondary;
    }

    protected void setSecondary(boolean secondary) {
        this.secondary = secondary;
    }

    public int getTier() {
        return this.tier;
    }

    protected void setTier(int tier) {
        this.tier = tier;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HeroClass)) {
            return false;
        }
        HeroClass other = (HeroClass)obj;
        return this.name.equalsIgnoreCase(other.name);
    }

    public boolean isAllowedArmor(Material mat) {
        return this.allowedArmor.contains(mat);
    }

    public Set<Material> getAllowedArmor() {
        return Collections.unmodifiableSet(this.allowedArmor);
    }

    public boolean isAllowedWeapon(Material mat) {
        return this.allowedWeapons.contains(mat);
    }

    public Set<Material> getAllowedWeapons() {
        return Collections.unmodifiableSet(this.allowedWeapons);
    }

    public int getBaseMaxHealth() {
        return this.baseMaxHealth;
    }

    public int getBaseMaxMana() {
        return this.baseMaxMana;
    }

    public double getCost() {
        return this.cost;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<ExperienceType> getExperienceSources() {
        return Collections.unmodifiableSet(this.experienceSources);
    }

    public boolean hasExperiencetype(ExperienceType type) {
        return this.experienceSources.contains((Object)type);
    }

    public double getExpLoss() {
        return this.expLoss;
    }

    public double getExpModifier() {
        return this.expModifier;
    }

    public Double getItemDamage(Material material) {
        return this.itemDamage.get(material);
    }

    public double getItemDamageLevel(Material mat) {
        return this.itemDamageLevel.containsKey(mat) ? this.itemDamageLevel.get(mat) : 0.0;
    }

    public double getMaxHealthPerLevel() {
        return this.maxHealthPerLevel;
    }

    public double getMaxManaPerLevel() {
        return this.maxManaPerLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public String getName() {
        return this.name;
    }

    public List<HeroClass> getParents() {
        ArrayList<HeroClass> parents = new ArrayList<HeroClass>(this.strongParents);
        parents.addAll(this.weakParents);
        return Collections.unmodifiableList(parents);
    }

    public Double getProjectileDamage(CharacterDamageManager.ProjectileType type) {
        return this.projectileDamage.get((Object)type);
    }

    public double getProjDamageLevel(CharacterDamageManager.ProjectileType type) {
        return this.projDamageLevel.containsKey((Object)type) ? this.projDamageLevel.get((Object)type) : 0.0;
    }

    public Set<String> getSkillNames() {
        return new TreeSet<String>(this.skills);
    }

    public Set<HeroClass> getSpecializations() {
        return Collections.unmodifiableSet(this.specializations);
    }

    public Set<HeroClass> getStrongParents() {
        return Collections.unmodifiableSet(this.strongParents);
    }

    public Set<HeroClass> getWeakParents() {
        return Collections.unmodifiableSet(this.weakParents);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean hasSkill(String name) {
        return this.skills.contains(name.toLowerCase());
    }

    public boolean hasNoParents() {
        return this.strongParents.isEmpty() && this.weakParents.isEmpty();
    }

    protected void setBaseMaxHealth(int baseMaxHealth) {
        this.baseMaxHealth = baseMaxHealth;
    }

    protected void setBaseMaxMana(int baseMaxMana) {
        this.baseMaxMana = baseMaxMana;
    }

    protected void setCost(double cost) {
        this.cost = cost;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setExperienceSources(Set<ExperienceType> experienceSources) {
        this.experienceSources = experienceSources;
    }

    protected void setExpLoss(double expLoss) {
        this.expLoss = expLoss;
    }

    public double getPvpExpLoss() {
        return this.pvpExpLoss;
    }

    public void setPvpExpLoss(double pvpExpLoss) {
        this.pvpExpLoss = pvpExpLoss;
    }

    protected void setExpModifier(double modifier) {
        this.expModifier = modifier;
    }

    protected void setItemDamage(Material material, double damage) {
        this.itemDamage.put(material, damage);
    }

    protected void setItemDamageLevel(Material material, double damage) {
        this.itemDamageLevel.put(material, damage);
    }

    protected void setMaxHealthPerLevel(double maxHealthPerLevel) {
        this.maxHealthPerLevel = maxHealthPerLevel;
    }

    protected void setMaxManaPerLevel(double maxManaPerLevel) {
        this.maxManaPerLevel = maxManaPerLevel;
    }

    protected void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    protected void setProjectileDamage(CharacterDamageManager.ProjectileType type, double damage) {
        this.projectileDamage.put(type, damage);
    }

    protected void setProjDamageLevel(CharacterDamageManager.ProjectileType type, double damage) {
        this.projDamageLevel.put(type, damage);
    }

    protected void setSpecializations(Set<HeroClass> specializations) {
        this.specializations = specializations;
    }

    public String toString() {
        return this.name;
    }

    public boolean isWildcardClass() {
        return this.wildcard;
    }

    protected void setWildcardClass(boolean wildcard) {
        this.wildcard = wildcard;
    }

    void addRecipe(RecipeGroup rg) {
        this.recipes.add(rg);
    }

    public double getManaRegen() {
        return this.manaRegen;
    }

    protected void setManaRegen(double manaRegen) {
        this.manaRegen = manaRegen;
    }

    public double getManaRegenPerLevel() {
        return this.manaRegenPerLevel;
    }

    protected void setManaRegenPerLevel(double manaRegenPerLevel) {
        this.manaRegenPerLevel = manaRegenPerLevel;
    }

    @Override
    public int compareTo(HeroClass other) {
        return this.name.compareTo(other.name);
    }

    public class CircularParentException
    extends Exception {
    }

    public static enum ExperienceType {
        SKILL,
        KILLING,
        PVP,
        MINING,
        ENCHANTING,
        FARMING,
        CRAFTING,
        LOGGING,
        DEATH,
        ADMIN,
        EXTERNAL,
        FISHING,
        QUESTING,
        BUILDING,
        SHEARING,
        TAMING;

    }
}

