/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.classes;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.gui.MenuHandler;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.RecipeGroup;
import com.herocraftonline.heroes.util.Util;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class HeroClassManager {
    private final Heroes plugin;
    private final Set<HeroClass> classes;
    private HeroClass defaultClass;
    private HashMap<HeroClass, Set<String>> weakParents = new HashMap();
    private HashMap<HeroClass, Set<String>> strongParents = new HashMap();

    public HeroClassManager(Heroes plugin) {
        this.plugin = plugin;
        this.classes = new TreeSet<HeroClass>();
    }

    public boolean addClass(HeroClass c) {
        return this.classes.add(c);
    }

    public HeroClass getClass(String name) {
        for (HeroClass c : this.classes) {
            if (!name.equalsIgnoreCase(c.getName())) continue;
            return c;
        }
        return null;
    }

    public Set<HeroClass> getClasses() {
        return this.classes;
    }

    public HeroClass getDefaultClass() {
        return this.defaultClass;
    }

    public boolean loadClasses(File file) {
        if (file.listFiles().length == 0) {
            Heroes.log(Level.WARNING, "You have no classes defined in your setup! Heroes will now disable itself!");
            return false;
        }
        for (File f : file.listFiles()) {
            if (!f.isFile() || !f.getName().contains(".yml")) continue;
            HeroClass newClass = this.loadClass(f);
            if (newClass == null) {
                Heroes.log(Level.WARNING, "Attempted to load " + f.getName() + " but failed. Skipping.");
                continue;
            }
            if (!this.addClass(newClass)) {
                Heroes.log(Level.WARNING, "Duplicate class (" + newClass.getName() + ") found. Skipping this class.");
                continue;
            }
            if (!Heroes.properties.debug) continue;
            Heroes.debugLog(Level.INFO, "Loaded class: " + newClass.getName());
        }
        this.checkClassHeirarchy();
        SkillConfigManager.saveSkillConfig();
        SkillConfigManager.setClassDefaults();
        if (this.defaultClass == null) {
            Heroes.log(Level.SEVERE, "You are missing a default class! Heroes will now disable itself!");
            return false;
        }
        if (this.plugin.getServer().getPluginManager().getPermission("heroes.classes.*") == null) {
            this.registerClassPermissions();
        }
        return true;
    }

    private HeroClass loadClass(File file) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String className = config.getString("name");
        if (className == null) {
            return null;
        }
        HeroClass newClass = new HeroClass(className, this.plugin);
        newClass.setDescription(config.getString("description", ""));
        newClass.setExpModifier(config.getDouble("expmodifier", 1.0));
        newClass.setPrimary(config.getBoolean("primary", true));
        newClass.setSecondary(config.getBoolean("secondary", false));
        newClass.setTier(config.getInt("tier", 1));
        if (newClass.getTier() < 0) {
            newClass.setTier(0);
        }
        this.loadArmor(newClass, config.getStringList("permitted-armor"));
        this.loadWeapons(newClass, config.getStringList("permitted-weapon"));
        this.loadDamages(newClass, (Configuration)config);
        this.loadPermittedSkills(newClass, config.getConfigurationSection("permitted-skills"));
        this.loadPermissionSkills(newClass, config.getConfigurationSection("permission-skills"));
        this.loadExperienceTypes(newClass, config.getStringList("experience-sources"));
        newClass.setWildcardClass(config.getBoolean("wildcard-permission", true));
        newClass.setBaseMaxHealth(config.getInt("base-max-health", 20));
        if (newClass.getBaseMaxHealth() <= 0) {
            Heroes.log(Level.SEVERE, "Invalid base health defined for: " + newClass.getName() + " please set higher than 0");
        }
        newClass.setMaxHealthPerLevel(config.getDouble("max-health-per-level", 0.0));
        newClass.setBaseMaxMana(config.getInt("base-max-mana", 100));
        newClass.setMaxManaPerLevel(config.getDouble("max-mana-per-level", 0.0));
        newClass.setManaRegen(config.getDouble("mana-regen", 1.0));
        newClass.setManaRegenPerLevel(config.getDouble("mana-regen-per-level", 0.0));
        if (config.isSet("recipes")) {
            for (String s : config.getStringList("recipes")) {
                RecipeGroup rg = Heroes.properties.recipes.get(s.toLowerCase());
                if (rg == null) {
                    Heroes.log(Level.SEVERE, "No recipe group named " + s + " defined in recipes.yml. Check " + className + " for errors or add the recipe group!");
                    continue;
                }
                newClass.addRecipe(rg);
            }
        } else {
            Heroes.log(Level.SEVERE, "Class " + className + " has no recipes set! They will not be able to craft items!");
        }
        newClass.setExpLoss(config.getDouble("expLoss", -1.0));
        newClass.setPvpExpLoss(config.getDouble("pvpExpLoss", -1.0));
        int defaultMaxLevel = Properties.maxLevel;
        int maxLevel = config.getInt("max-level", defaultMaxLevel);
        if (maxLevel < 1) {
            Heroes.log(Level.WARNING, "Class (" + className + ") max level is too low. Setting max level to 1.");
            maxLevel = 1;
        } else if (maxLevel > defaultMaxLevel) {
            Heroes.log(Level.WARNING, "Class (" + className + ") max level is too high. Setting max level to " + defaultMaxLevel + ".");
            maxLevel = defaultMaxLevel;
        }
        newClass.setMaxLevel(maxLevel);
        double defaultCost = 0.0;
        defaultCost = newClass.isPrimary() ? Heroes.properties.swapCost : Heroes.properties.profSwapCost;
        double cost = config.getDouble("cost", defaultCost);
        if (cost < 0.0) {
            Heroes.log(Level.WARNING, "Class (" + className + ") cost is too low. Setting cost to 0.");
            cost = 0.0;
        }
        newClass.setCost(cost);
        HashSet strongParents = new HashSet();
        if (config.isConfigurationSection("parents")) {
            List list = config.getStringList("parents.strong");
            if (list != null) {
                strongParents.addAll(list);
            }
            list = config.getStringList("parents.weak");
            HashSet weakParents = new HashSet();
            if (list != null) {
                weakParents.addAll(list);
            }
            this.weakParents.put(newClass, weakParents);
            this.strongParents.put(newClass, strongParents);
        }
        if (config.getBoolean("default", false)) {
            if (Heroes.properties.debug) {
                Heroes.debugLog(Level.INFO, "Default class found: " + className);
            }
            this.defaultClass = newClass;
        }
        if (Heroes.useSMS) {
            MenuHandler.setupMenu(newClass, this.plugin);
        }
        return newClass;
    }

    private void registerClassPermissions() {
        HashMap<String, Boolean> classPermissions = new HashMap<String, Boolean>();
        for (HeroClass heroClass : this.classes) {
            Permission p;
            if (heroClass.isWildcardClass()) {
                p = new Permission("heroes.classes." + heroClass.getName().toLowerCase(), PermissionDefault.OP);
                Bukkit.getServer().getPluginManager().addPermission(p);
                classPermissions.put("heroes.classes." + heroClass.getName().toLowerCase(), true);
                continue;
            }
            p = new Permission("heroes.classes." + heroClass.getName().toLowerCase(), PermissionDefault.OP);
            Bukkit.getServer().getPluginManager().addPermission(p);
        }
        Permission wildcardClassPermission = new Permission("heroes.classes.*", "Grants access to all classes.", PermissionDefault.OP, classPermissions);
        this.plugin.getServer().getPluginManager().addPermission(wildcardClassPermission);
    }

    private void loadDamages(HeroClass newClass, Configuration config) {
        CharacterDamageManager.ProjectileType type;
        Set projectileDamages;
        Material material;
        Set itemDamages;
        String className = newClass.getName();
        ConfigurationSection section = config.getConfigurationSection("item-damage");
        if (section != null) {
            itemDamages = section.getKeys(false);
            if (itemDamages == null || itemDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has no item-damage section");
            } else {
                for (String materialName : itemDamages) {
                    material = Material.matchMaterial((String)materialName);
                    if (material != null && section.get(materialName) instanceof Number) {
                        int damage = section.getInt(materialName);
                        newClass.setItemDamage(material, damage);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid item-damage (" + materialName + ") defined for " + className);
                }
            }
        }
        if ((section = config.getConfigurationSection("item-damage-level")) != null) {
            itemDamages = section.getKeys(false);
            if (itemDamages == null || itemDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has no item-damage-level section");
            } else {
                for (String materialName : itemDamages) {
                    material = Material.matchMaterial((String)materialName);
                    if (material != null && section.get(materialName) instanceof Number) {
                        double damage = section.getDouble(materialName);
                        newClass.setItemDamageLevel(material, damage);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid item-damage-level (" + materialName + ") defined for " + className);
                }
            }
        }
        if ((section = config.getConfigurationSection("projectile-damage")) != null) {
            projectileDamages = section.getKeys(false);
            if (projectileDamages == null || projectileDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has no projectile damage section");
            } else {
                for (String projectileName : projectileDamages) {
                    type = CharacterDamageManager.ProjectileType.matchProjectile(projectileName);
                    if (type != null && section.get(projectileName) instanceof Number) {
                        int damage = section.getInt(projectileName);
                        newClass.setProjectileDamage(type, damage);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid projectile-damage type or value for (" + projectileName + ") defined in " + className);
                }
            }
        }
        if ((section = config.getConfigurationSection("projectile-damage-level")) != null) {
            projectileDamages = section.getKeys(false);
            if (projectileDamages == null || projectileDamages.isEmpty()) {
                Heroes.log(Level.WARNING, className + " has no projectile damage section");
            } else {
                for (String projectileName : projectileDamages) {
                    type = CharacterDamageManager.ProjectileType.matchProjectile(projectileName);
                    if (type != null && section.get(projectileName) instanceof Number) {
                        double damage = section.getDouble(projectileName);
                        newClass.setProjDamageLevel(type, damage);
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Invalid projectile-damage-level type or value for (" + projectileName + ") defined in " + className);
                }
            }
        }
    }

    private void loadWeapons(HeroClass newClass, List<String> weapons) {
        StringBuilder wLimits = new StringBuilder();
        String className = newClass.getName();
        if (weapons == null || weapons.isEmpty()) {
            Heroes.log(Level.WARNING, className + " has no permitted-weapon section");
            return;
        }
        for (String w : weapons) {
            boolean matched = false;
            for (String s : Util.weapons) {
                if (w.equals("*") || w.equalsIgnoreCase("ALL")) {
                    newClass.addAllowedWeapon(Material.matchMaterial((String)s));
                    wLimits.append(" ").append(s);
                    matched = true;
                    continue;
                }
                if (!s.contains(w.toUpperCase()) || s.contains("PICK") && !w.contains("PICK") && w.contains("AXE")) continue;
                newClass.addAllowedWeapon(Material.matchMaterial((String)s));
                wLimits.append(" ").append(s);
                matched = true;
            }
            if (w.equals("*") || w.equals("ALL")) break;
            if (matched) continue;
            Heroes.log(Level.WARNING, "Invalid weapon type (" + w + ") defined for " + className);
        }
        if (Heroes.properties.debug) {
            Heroes.debugLog(Level.INFO, "Allowed Weapons - " + wLimits.toString());
        }
    }

    public boolean removeClass(HeroClass c) {
        return this.classes.remove(c);
    }

    public void setDefaultClass(HeroClass defaultClass) {
        this.defaultClass = defaultClass;
    }

    private void checkClassHeirarchy() {
        for (HeroClass unlinkedClass : this.classes) {
            Set<String> weak;
            Set<String> strong = this.strongParents.get(unlinkedClass);
            if (strong != null && !strong.isEmpty()) {
                for (String sp : strong) {
                    HeroClass parent = this.getClass(sp);
                    if (parent != null) {
                        try {
                            unlinkedClass.addStrongParent(parent);
                            parent.addSpecialization(unlinkedClass);
                        }
                        catch (HeroClass.CircularParentException e) {
                            Heroes.log(Level.SEVERE, "Cannot assign " + unlinkedClass.getName() + " as a parent class as " + sp + " is already a parent of that class.");
                        }
                        continue;
                    }
                    Heroes.log(Level.WARNING, "Cannot assign " + unlinkedClass.getName() + " a parent class as " + sp + " does not exist.");
                }
            }
            if ((weak = this.weakParents.get(unlinkedClass)) == null || weak.isEmpty()) continue;
            for (String wp : weak) {
                HeroClass parent = this.getClass(wp);
                if (parent != null) {
                    try {
                        unlinkedClass.addWeakParent(parent);
                        parent.addSpecialization(unlinkedClass);
                    }
                    catch (HeroClass.CircularParentException e) {
                        Heroes.log(Level.SEVERE, "Cannot assign " + unlinkedClass.getName() + " as a parent class as " + wp + " is already a parent of that class.");
                    }
                    continue;
                }
                Heroes.log(Level.WARNING, "Cannot assign " + unlinkedClass.getName() + " a parent class as " + wp + " does not exist.");
            }
        }
        this.strongParents.clear();
        this.strongParents = null;
        this.weakParents.clear();
        this.weakParents = null;
    }

    private void loadArmor(HeroClass newClass, List<String> armors) {
        StringBuilder aLimits = new StringBuilder();
        String className = newClass.getName();
        if (armors == null || armors.isEmpty()) {
            Heroes.log(Level.WARNING, className + " has no permitted-armor section");
            return;
        }
        for (String a : armors) {
            boolean matched = false;
            for (String s : Util.armors) {
                if (!s.contains(a.toUpperCase()) && !a.equals("*") && !a.equalsIgnoreCase("ALL")) continue;
                newClass.addAllowedArmor(Material.matchMaterial((String)s));
                aLimits.append(" ").append(s);
                matched = true;
            }
            if (a.equals("*") || a.equals("ALL")) break;
            if (matched) continue;
            Heroes.log(Level.WARNING, "Invalid armor type (" + a + ") defined for " + className);
        }
        if (Heroes.properties.debug) {
            Heroes.debugLog(Level.INFO, "Allowed Armor - " + aLimits.toString());
        }
    }

    private void loadExperienceTypes(HeroClass newClass, List<String> experienceNames) {
        String className = newClass.getName();
        EnumSet<HeroClass.ExperienceType> experienceSources = EnumSet.noneOf(HeroClass.ExperienceType.class);
        if (experienceNames == null || experienceNames.isEmpty()) {
            Heroes.log(Level.WARNING, className + " has no experience-sources section");
        } else {
            for (String experience : experienceNames) {
                try {
                    boolean added = experienceSources.add(HeroClass.ExperienceType.valueOf(experience.toUpperCase()));
                    if (added) continue;
                    Heroes.log(Level.WARNING, "Duplicate experience source (" + experience + ") defined for " + className + ".");
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid experience source (" + experience + ") defined for " + className + ". Skipping this source.");
                }
            }
        }
        newClass.setExperienceSources(experienceSources);
    }

    private void loadPermissionSkills(HeroClass newClass, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        String className = newClass.getName();
        Set permissionSkillNames = section.getKeys(false);
        if (permissionSkillNames != null) {
            for (String skill : permissionSkillNames) {
                if (newClass.hasSkill(skill)) {
                    Heroes.log(Level.WARNING, "Skill already assigned (" + skill + ") for " + className + ". Skipping this skill");
                    continue;
                }
                try {
                    if (!this.plugin.getSkillManager().isLoaded(skill) && !this.plugin.getSkillManager().loadOutsourcedSkill(skill)) continue;
                    newClass.addSkill(skill);
                    ConfigurationSection skillSettings = section.getConfigurationSection(skill);
                    if (skillSettings == null) {
                        skillSettings = section.createSection(skill);
                    }
                    this.plugin.getSkillConfigs().addClassSkillSettings(className, this.plugin.getSkillManager().getSkill(skill).getName(), skillSettings);
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid permission skill (" + skill + ") defined for " + className + ". Skipping this skill.");
                }
            }
        }
    }

    private void loadPermittedSkills(HeroClass newClass, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        String className = newClass.getName();
        Set skillNames = section.getKeys(false);
        if (skillNames.isEmpty()) {
            Heroes.log(Level.WARNING, className + " has no permitted-skills section");
        } else {
            boolean allSkills = false;
            for (String skillName : skillNames) {
                if (skillName.equals("*") || skillName.toLowerCase().equals("all")) {
                    allSkills = true;
                    continue;
                }
                Skill skill = this.plugin.getSkillManager().getSkill(skillName);
                if (skill == null) {
                    Heroes.log(Level.WARNING, "Skill " + skillName + " defined for " + className + " not found.");
                    continue;
                }
                newClass.addSkill(skillName);
                ConfigurationSection skillSettings = section.getConfigurationSection(skillName);
                if (skillSettings == null) {
                    skillSettings = section.createSection(skillName);
                }
                this.plugin.getSkillConfigs().addClassSkillSettings(className, skill.getName(), skillSettings);
            }
            if (allSkills) {
                this.plugin.getSkillManager().loadSkills();
                for (Skill skill : this.plugin.getSkillManager().getSkills()) {
                    if (newClass.hasSkill(skill.getName()) || skill instanceof OutsourcedSkill) continue;
                    newClass.addSkill(skill.getName());
                    ConfigurationSection skillSettings = section.getConfigurationSection(skill.getName());
                    if (skillSettings == null) {
                        skillSettings = section.createSection(skill.getName());
                    }
                    this.plugin.getSkillConfigs().addClassSkillSettings(newClass.getName(), skill.getName(), skillSettings);
                }
            }
        }
    }
}

