/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BloodUnionEffect
extends Effect {
    private int expireDuration;
    private int maxBloodUnion;
    private int bloodUnionLevel;
    private boolean lastTargetPlayer;
    private Player player;
    private Skill skill;

    public BloodUnionEffect(Skill skill, int expireDuration, int maxBloodUnion) {
        super(skill, "BloodUnionEffect");
        this.expireDuration = expireDuration;
        this.maxBloodUnion = maxBloodUnion;
        this.bloodUnionLevel = 0;
        this.lastTargetPlayer = false;
        this.skill = skill;
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        this.player = hero.getPlayer();
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
    }

    public int getBloodUnionLevel() {
        return this.bloodUnionLevel;
    }

    public void setBloodUnionLevel(int bloodUnionLevel) {
        this.bloodUnionLevel = bloodUnionLevel >= this.maxBloodUnion ? this.maxBloodUnion : (bloodUnionLevel <= 0 ? 0 : bloodUnionLevel);
        Messaging.send((CommandSender)this.player, "Curent BloodUnion Level: " + this.bloodUnionLevel, new Object[0]);
    }

    public void addBloodUnion(int bloodUnionIncrease, boolean isPlayer) {
        Hero hero = this.skill.plugin.getCharacterManager().getHero(this.player);
        if (hero.hasEffect("BloodUnionDecayEffect")) {
            BloodUnionDecayEffect buDecayEffect = (BloodUnionDecayEffect)hero.getEffect("BloodUnionDecayEffect");
            buDecayEffect.decreaseBloodUnion = false;
            hero.removeEffect(buDecayEffect);
        }
        if (!this.lastTargetPlayer && isPlayer || this.lastTargetPlayer && !isPlayer) {
            this.setBloodUnionLevel(bloodUnionIncrease);
        } else if (this.lastTargetPlayer && isPlayer || !this.lastTargetPlayer && !isPlayer) {
            this.setBloodUnionLevel(this.bloodUnionLevel + bloodUnionIncrease);
        }
        this.lastTargetPlayer = isPlayer;
        hero.addEffect(new BloodUnionDecayEffect(this.skill, (long)this.expireDuration));
    }

    public void decreaseBloodUnion(int bloodUnionDecrease) {
        this.setBloodUnionLevel(this.bloodUnionLevel - bloodUnionDecrease);
    }

    public class BloodUnionDecayEffect
    extends ExpirableEffect {
        public boolean decreaseBloodUnion;

        public BloodUnionDecayEffect(Skill skill, long duration) {
            super(skill, "BloodUnionDecayEffect", duration);
            this.decreaseBloodUnion = true;
        }

        @Override
        public void applyToHero(Hero hero) {
            super.applyToHero(hero);
        }

        @Override
        public void removeFromHero(Hero hero) {
            super.removeFromHero(hero);
            if (this.decreaseBloodUnion && hero.hasEffect("BloodUnionEffect")) {
                BloodUnionEffect buEffect = (BloodUnionEffect)hero.getEffect("BloodUnionEffect");
                buEffect.setBloodUnionLevel(0);
            }
        }
    }
}

