/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.nms.NMSHandler;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Effect {
    protected final String name;
    protected final Skill skill;
    protected final Heroes plugin;
    public final Set<EffectType> types = EnumSet.noneOf(EffectType.class);
    protected long applyTime;
    private boolean persistent = false;
    private final Set<PotionEffect> potionEffects = new HashSet<PotionEffect>();
    private final Set<PotionEffect> mobEffects = new HashSet<PotionEffect>();

    public Effect(Skill skill, String name) {
        this(skill == null ? null : skill.plugin, skill, name, new EffectType[0]);
    }

    public Effect(Skill skill, String name, EffectType ... types) {
        this(skill.plugin, skill, name, types);
    }

    public Effect(Heroes plugin, Skill skill, String name, EffectType ... types) {
        this.name = name;
        this.skill = skill;
        this.plugin = plugin;
        if (types != null) {
            for (EffectType type : types) {
                this.types.add(type);
            }
        }
    }

    public void apply(CharacterTemplate character) {
        if (character instanceof Hero) {
            this.applyToHero((Hero)character);
        } else if (character instanceof Monster) {
            this.applyToMonster((Monster)character);
        }
    }

    public void applyToMonster(Monster monster) {
        this.applyTime = System.currentTimeMillis();
        if (!this.potionEffects.isEmpty()) {
            LivingEntity le = monster.getEntity();
            for (PotionEffect pEffect : this.potionEffects) {
                le.addPotionEffect(pEffect);
            }
        }
    }

    public void applyToHero(Hero hero) {
        this.applyTime = System.currentTimeMillis();
        if (!this.potionEffects.isEmpty()) {
            Player p = hero.getPlayer();
            for (PotionEffect pEffect : this.potionEffects) {
                p.addPotionEffect(pEffect);
            }
            if (!this.mobEffects.isEmpty()) {
                NMSHandler.getInterface().sendFakePotionEffectPackets(this.mobEffects, p);
            }
        }
    }

    public void reapplyToHero(Hero hero) {
        Player p = hero.getPlayer();
        for (PotionEffect pEffect : this.potionEffects) {
            p.addPotionEffect(pEffect, true);
        }
        NMSHandler nmsHandler = NMSHandler.getInterface();
        nmsHandler.sendFakePotionEffectPackets(this.mobEffects, p);
    }

    public void remove(CharacterTemplate character) {
        if (character instanceof Hero) {
            this.removeFromHero((Hero)character);
        } else if (character instanceof Monster) {
            this.removeFromMonster((Monster)character);
        }
    }

    public void removeFromMonster(Monster monster) {
        if (!this.potionEffects.isEmpty()) {
            LivingEntity lE = monster.getEntity();
            for (PotionEffect pEffect : this.potionEffects) {
                lE.removePotionEffect(pEffect.getType());
            }
        }
    }

    public void removeFromHero(Hero hero) {
        Player p = hero.getPlayer();
        if (!this.potionEffects.isEmpty()) {
            for (PotionEffect pEffect : this.potionEffects) {
                p.removePotionEffect(pEffect.getType());
            }
        }
        if (!this.mobEffects.isEmpty()) {
            NMSHandler nmsHandler = NMSHandler.getInterface();
            nmsHandler.removeFakePotionEffectPackets(this.mobEffects, p);
        }
    }

    public void broadcast(Location source, String message, Object ... args) {
        this.skill.broadcast(source, message, args);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Effect other = (Effect)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getName() {
        return this.name;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public long getApplyTime() {
        return this.applyTime;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isType(EffectType type) {
        return this.types.contains((Object)type);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void addMobEffect(int id, int duration, int strength, boolean faked) {
        this.addPotionEffect(id, duration, strength, faked);
    }

    public Set<PotionEffect> getMobEffects() {
        return Collections.unmodifiableSet(this.mobEffects);
    }

    public Set<PotionEffect> getPotionEffects() {
        return Collections.unmodifiableSet(this.potionEffects);
    }

    public void addPotionEffect(int id, int duration, int strength, boolean faked) {
        if (!faked) {
            this.potionEffects.add(new PotionEffect(PotionEffectType.getById((int)id), duration, strength));
        } else {
            this.mobEffects.add(new PotionEffect(PotionEffectType.getById((int)id), duration, strength));
        }
    }

    public void addPotionEffect(PotionEffect pEffect, boolean faked) {
        if (!faked) {
            this.potionEffects.add(pEffect);
        } else {
            this.mobEffects.add(pEffect);
        }
    }
}

