/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.Expirable;
import com.herocraftonline.heroes.characters.effects.ManagedEffect;
import com.herocraftonline.heroes.characters.effects.Periodic;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class EffectManager {
    private final Set<ManagedEffect> managedEffects = new HashSet<ManagedEffect>();
    private final Set<ManagedEffect> pendingRemovals = new HashSet<ManagedEffect>();
    private final Set<ManagedEffect> pendingAdditions = new HashSet<ManagedEffect>();
    private static final int effectInterval = 2;

    public EffectManager(Heroes plugin) {
        EffectUpdater effectTimer = new EffectUpdater();
        plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)effectTimer, 0L, 2L);
    }

    public void manageEffect(CharacterTemplate character, Effect effect) {
        if (effect instanceof Expirable || effect instanceof Periodic) {
            this.pendingAdditions.add(new ManagedEffect(character, effect));
        }
    }

    public void queueForRemoval(CharacterTemplate character, Effect effect) {
        ManagedEffect mEffect = new ManagedEffect(character, effect);
        if (this.managedEffects.contains(mEffect)) {
            this.pendingRemovals.add(mEffect);
        }
    }

    class EffectUpdater
    implements Runnable {
        EffectUpdater() {
        }

        @Override
        public void run() {
            HashSet removals = new HashSet(EffectManager.this.pendingRemovals);
            EffectManager.this.pendingRemovals.clear();
            for (ManagedEffect managed : removals) {
                EffectManager.this.managedEffects.remove(managed);
            }
            HashSet additions = new HashSet(EffectManager.this.pendingAdditions);
            EffectManager.this.pendingAdditions.clear();
            for (ManagedEffect managed : additions) {
                EffectManager.this.managedEffects.add(managed);
            }
            for (ManagedEffect managed : EffectManager.this.managedEffects) {
                if (managed.effect instanceof Expirable && ((Expirable)((Object)managed.effect)).isExpired()) {
                    try {
                        managed.character.removeEffect(managed.effect);
                    }
                    catch (Exception e) {
                        Heroes.log(Level.SEVERE, "There was an error attempting to remove effect: " + managed.effect.getName());
                        e.printStackTrace();
                    }
                }
                if (!(managed.effect instanceof Periodic)) continue;
                Periodic periodic = (Periodic)((Object)managed.effect);
                try {
                    if (!periodic.isReady()) continue;
                    periodic.tick(managed.character);
                }
                catch (Exception e) {
                    Heroes.log(Level.SEVERE, "There was an error attempting to tick effect: " + managed.effect.getName());
                    e.printStackTrace();
                }
            }
        }
    }
}

