/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.Expirable;
import com.herocraftonline.heroes.characters.skill.Skill;

public class ExpirableEffect
extends Effect
implements Expirable {
    private final long duration;
    private long expireTime;

    public ExpirableEffect(Skill skill, String name, long duration) {
        super(skill, name);
        this.duration = duration;
    }

    public ExpirableEffect(Skill skill, Heroes plugin, String name, long duration) {
        super(plugin, skill, name, new EffectType[0]);
        this.duration = duration;
    }

    @Override
    public void applyToMonster(Monster monster) {
        super.applyToMonster(monster);
        this.expireTime = this.applyTime + this.duration;
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        this.expireTime = this.applyTime + this.duration;
    }

    @Override
    public long getApplyTime() {
        return this.applyTime;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getExpiry() {
        return this.expireTime;
    }

    @Override
    public long getRemainingTime() {
        return this.expireTime - System.currentTimeMillis();
    }

    @Override
    public boolean isExpired() {
        if (this.isPersistent()) {
            return false;
        }
        return System.currentTimeMillis() >= this.getExpiry();
    }

    @Override
    public void expire() {
        this.expireTime = System.currentTimeMillis();
    }

    @Override
    public void removeFromMonster(Monster monster) {
        super.removeFromMonster(monster);
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
    }
}

