/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;

public class PeriodicDamageEffect
extends PeriodicExpirableEffect {
    protected double tickDamage;
    protected Player applier;
    protected Hero applyHero;
    private final boolean knockback;

    @Deprecated
    public PeriodicDamageEffect(Skill skill, String name, long period, long duration, int tickDamage, Player applier, boolean knockback) {
        this(skill, name, period, duration, Math.ceil(tickDamage), applier, knockback);
    }

    @Deprecated
    public PeriodicDamageEffect(Skill skill, String name, long period, long duration, int tickDamage, Player applier) {
        this(skill, name, period, duration, Math.ceil(tickDamage), applier, false);
    }

    public PeriodicDamageEffect(Skill skill, String name, long period, long duration, double tickDamage, Player applier) {
        this(skill, name, period, duration, tickDamage, applier, false);
    }

    public PeriodicDamageEffect(Skill skill, String name, long period, long duration, double tickDamage, Player applier, boolean knockback) {
        super(skill, name, period, duration);
        this.tickDamage = tickDamage;
        this.applier = applier;
        this.applyHero = this.plugin.getCharacterManager().getHero(applier);
        this.types.add(EffectType.HARMFUL);
        this.knockback = knockback;
    }

    public void setApplier(Player applier) {
        this.applier = applier;
        this.applyHero = this.plugin.getCharacterManager().getHero(applier);
    }

    public Player getApplier() {
        return this.applier;
    }

    public void setApplierHero(Hero applyHero) {
        this.applyHero = applyHero;
        this.applier = applyHero.getPlayer();
    }

    public Hero getApplierHero() {
        return this.applyHero;
    }

    public double getTickDamage() {
        return this.tickDamage;
    }

    public void setTickDamage(double tickDamage) {
        this.tickDamage = tickDamage;
    }

    @Override
    public void tickMonster(Monster monster) {
        this.skill.addSpellTarget((Entity)monster.getEntity(), this.applyHero);
        Skill.damageEntity(monster.getEntity(), (LivingEntity)this.applier, this.tickDamage, this.skill.isType(SkillType.PHYSICAL) ? EntityDamageEvent.DamageCause.ENTITY_ATTACK : EntityDamageEvent.DamageCause.MAGIC, this.knockback);
    }

    @Override
    public void tickHero(Hero hero) {
        Player player = hero.getPlayer();
        if (!Skill.damageCheck(this.applier, (LivingEntity)player)) {
            return;
        }
        this.skill.addSpellTarget((Entity)player, this.applyHero);
        Skill.damageEntity((LivingEntity)player, (LivingEntity)this.applier, this.tickDamage, this.skill.isType(SkillType.PHYSICAL) ? EntityDamageEvent.DamageCause.ENTITY_ATTACK : EntityDamageEvent.DamageCause.MAGIC, this.knockback);
    }
}

