/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.effects.Periodic;
import com.herocraftonline.heroes.characters.skill.Skill;

public abstract class PeriodicExpirableEffect
extends ExpirableEffect
implements Periodic {
    private final long period;
    protected long lastTickTime = 0L;

    public PeriodicExpirableEffect(Skill skill, String name, long period, long duration) {
        super(skill, name, duration);
        this.period = period;
    }

    public PeriodicExpirableEffect(Skill skill, Heroes plugin, String name, long period, long duration) {
        super(skill, plugin, name, duration);
        this.period = period;
    }

    @Override
    public long getLastTickTime() {
        return this.lastTickTime;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    @Override
    public boolean isReady() {
        return System.currentTimeMillis() >= this.lastTickTime + this.period;
    }

    @Override
    public void removeFromMonster(Monster monster) {
        super.removeFromMonster(monster);
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
    }

    @Override
    public void tick(CharacterTemplate character) {
        this.lastTickTime = System.currentTimeMillis();
        if (character instanceof Hero) {
            this.tickHero((Hero)character);
        } else if (character instanceof Monster) {
            this.tickMonster((Monster)character);
        }
    }
}

