/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroRegainHealthEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PeriodicHealEffect
extends PeriodicExpirableEffect {
    private double tickHealth;
    private Player applier;
    private Hero healer;

    @Deprecated
    public PeriodicHealEffect(Heroes plugin, String name, long period, long duration, int tickHealth, Player applier) {
        this(plugin, name, period, duration, Math.ceil(tickHealth), applier);
    }

    @Deprecated
    public PeriodicHealEffect(Skill skill, String name, long period, long duration, int tickHealth, Player applier) {
        this(skill, name, period, duration, Math.ceil(tickHealth), applier);
    }

    public PeriodicHealEffect(Heroes plugin, String name, long period, long duration, double tickHealth, Player applier) {
        super(null, plugin, name, period, duration);
        this.tickHealth = tickHealth;
        this.applier = applier;
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.HEAL);
        this.healer = plugin.getCharacterManager().getHero(applier);
    }

    public PeriodicHealEffect(Skill skill, String name, long period, long duration, double tickHealth, Player applier) {
        super(skill, name, period, duration);
        this.tickHealth = tickHealth;
        this.applier = applier;
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.HEAL);
        this.healer = this.plugin.getCharacterManager().getHero(applier);
    }

    public void setApplier(Player applier) {
        this.applier = applier;
        this.healer = this.plugin.getCharacterManager().getHero(applier);
    }

    public Player getApplier() {
        return this.applier;
    }

    public void setApplierHero(Hero healer) {
        this.healer = healer;
        this.applier = healer.getPlayer();
    }

    public double getTickDamage() {
        return this.tickHealth;
    }

    public void setTickHealth(double tickHealth) {
        this.tickHealth = tickHealth;
    }

    @Override
    public void tickHero(Hero hero) {
        HeroRegainHealthEvent hrhEvent = new HeroRegainHealthEvent(hero, this.tickHealth, this.skill, this.healer);
        this.plugin.getServer().getPluginManager().callEvent((Event)hrhEvent);
        if (hrhEvent.isCancelled()) {
            return;
        }
        hero.heal(hrhEvent.getAmount());
    }

    @Override
    public void tickMonster(Monster monster) {
        double health = monster.getEntity().getHealth();
        if (health + this.tickHealth > monster.getEntity().getMaxHealth()) {
            monster.getEntity().setHealth(monster.getEntity().getMaxHealth());
        } else {
            monster.getEntity().setHealth(this.tickHealth + monster.getEntity().getHealth());
        }
    }
}

