/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BlindEffect
extends ExpirableEffect {
    private final String applyText;
    private final String expireText;

    public BlindEffect(Skill skill, long duration, String applyText, String expireText) {
        super(skill, "Blind", duration);
        this.applyText = applyText;
        this.expireText = expireText;
        this.types.add(EffectType.DISPELLABLE);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.BLIND);
        this.addMobEffect(9, (int)((duration + 4000L) / 1000L * 20L), 1, false);
        this.addMobEffect(15, (int)(duration / 1000L * 20L), 1, false);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        final Player player = hero.getPlayer();
        final int currentHunger = player.getFoodLevel();
        player.setFoodLevel(1);
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                player.setFoodLevel(currentHunger);
            }
        }, 2L);
        this.broadcast(player.getLocation(), this.applyText, player.getDisplayName());
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), this.expireText, player.getDisplayName());
    }
}

