/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class CombustEffect
extends PeriodicExpirableEffect {
    private final Player applier;
    private boolean expired = false;
    private int lastFireTickCount = -1;

    public CombustEffect(Skill skill, Player applier) {
        super(skill, "Combust", 10L, 0L);
        this.types.add(EffectType.FIRE);
        this.setPersistent(true);
        this.applier = applier;
    }

    @Override
    public void applyToMonster(Monster monster) {
        super.applyToMonster(monster);
        this.lastFireTickCount = monster.getEntity().getFireTicks();
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        this.lastFireTickCount = hero.getPlayer().getFireTicks();
    }

    public Player getApplier() {
        return this.applier;
    }

    @Override
    public boolean isExpired() {
        return this.expired;
    }

    @Override
    public void removeFromMonster(Monster monster) {
        super.removeFromMonster(monster);
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
    }

    @Override
    public void tickMonster(Monster monster) {
        int fireTicks = monster.getEntity().getFireTicks();
        if (fireTicks == 0) {
            this.expired = true;
        }
        if (this.lastFireTickCount - fireTicks >= 10) {
            monster.getEntity().setNoDamageTicks(0);
        }
        this.lastFireTickCount = fireTicks;
    }

    @Override
    public void tickHero(Hero hero) {
        int fireTicks;
        Player player = hero.getPlayer();
        if (player.getFireTicks() == 0) {
            this.expired = true;
        }
        if (this.lastFireTickCount - (fireTicks = player.getFireTicks()) >= 10) {
            player.setNoDamageTicks(0);
        }
        this.lastFireTickCount = fireTicks;
    }
}

