/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.util.Util;
import java.util.HashMap;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class DisarmEffect
extends ExpirableEffect {
    private final String applyText;
    private final String expireText;
    private final HashMap<Hero, ItemStack[]> disarms = new HashMap();

    public DisarmEffect(Skill skill, long duration, String applyText, String expireText) {
        super(skill, "Disarm", duration);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.DISARM);
        this.applyText = applyText;
        this.expireText = expireText;
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        ItemStack[] inv = player.getInventory().getContents();
        for (int i = 0; i < 9; ++i) {
            ItemStack is = inv[i];
            if (is == null || !Util.isWeapon(is.getType()) && !Util.isAwkwardWeapon(is.getType())) continue;
            if (!this.disarms.containsKey(hero)) {
                ItemStack[] disarmedItems = new ItemStack[9];
                disarmedItems[i] = is.clone();
                this.disarms.put(hero, disarmedItems);
                player.getInventory().clear(i);
                continue;
            }
            ItemStack[] items = this.disarms.get(hero);
            items[i] = is;
            player.getInventory().clear(i);
        }
        Util.syncInventory(player, this.plugin);
        this.broadcast(player.getLocation(), this.applyText, player.getDisplayName());
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        if (this.disarms.containsKey(hero)) {
            PlayerInventory inv = player.getInventory();
            ItemStack[] contents = inv.getContents();
            ItemStack[] oldInv = this.disarms.get(hero);
            for (int i = 0; i < 9; ++i) {
                if (oldInv[i] == null) continue;
                if (contents[i] != null) {
                    Util.moveItem(hero, i, contents[i]);
                }
                inv.setItem(i, oldInv[i]);
            }
            this.disarms.remove(hero);
            Util.syncInventory(player, this.plugin);
        }
        this.broadcast(player.getLocation(), this.expireText, player.getDisplayName());
    }
}

