/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.command.CommandSender;

public class ImbueEffect
extends Effect {
    private String description;

    public ImbueEffect(Skill skill, String name) {
        super(skill, name);
        this.types.add(EffectType.IMBUE);
        this.types.add(EffectType.BENEFICIAL);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        for (Effect effect : hero.getEffects()) {
            if (effect.equals(this) || !effect.isType(EffectType.IMBUE)) continue;
            hero.removeEffect(effect);
        }
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Messaging.send((CommandSender)hero.getPlayer(), "\u00a77[\u00a72Skill\u00a77] Your weapon is no longer imbued with $1", this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }
}

