/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.util.Messaging;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Spider;

public class InvisibleEffect
extends ExpirableEffect {
    public static final Set<String> hiddenPlayers = new HashSet<String>();
    private final String applyText;
    private final String expireText;

    public InvisibleEffect(Skill skill, long duration, String applyText, String expireText) {
        super(skill, "Invisible", duration);
        this.applyText = applyText;
        this.expireText = expireText;
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.INVIS);
        this.types.add(EffectType.UNTARGETABLE_NO_MSG);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (onlinePlayer.equals(player) || onlinePlayer.hasPermission("heroes.admin.seeinvis")) continue;
            onlinePlayer.hidePlayer(player);
        }
        hiddenPlayers.add(player.getName());
        for (Entity entity : player.getNearbyEntities(50.0, 30.0, 50.0)) {
            if (!(entity instanceof Monster)) continue;
            if (entity.getType().equals((Object)EntityType.SPIDER) || entity.getType().equals((Object)EntityType.CAVE_SPIDER)) {
                Spider spider = (Spider)entity;
                if (spider.getTarget() == null || !spider.getTarget().equals(player)) continue;
                spider.setTarget(null);
                continue;
            }
            Monster monster = (Monster)entity;
            LivingEntity target = monster.getTarget();
            if (!target.equals(player)) continue;
            monster.setTarget(null);
        }
        if (this.applyText != null && this.applyText.length() > 0) {
            Messaging.send((CommandSender)player, this.applyText, player.getDisplayName());
        }
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (onlinePlayer.equals(player)) continue;
            onlinePlayer.showPlayer(player);
        }
        hiddenPlayers.remove(player.getName());
        if (this.expireText != null && this.expireText.length() > 0) {
            Messaging.send((CommandSender)player, this.expireText, player.getDisplayName());
        }
    }
}

