/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class QuickenEffect
extends ExpirableEffect {
    private final String applyText;
    private final String expireText;

    public QuickenEffect(Skill skill, String name, long duration, int amplifier, String applyText, String expireText) {
        super(skill, name, duration);
        this.types.add(EffectType.DISPELLABLE);
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.MAGIC);
        this.addMobEffect(1, (int)(duration / 1000L) * 20, amplifier, false);
        this.applyText = applyText;
        this.expireText = expireText;
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), this.applyText, player.getDisplayName());
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), this.expireText, player.getDisplayName());
    }
}

