/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.entity.Player;

public class RootEffect
extends ExpirableEffect {
    private final String applyText = "\u00a77[\u00a72Skill\u00a77] $1 was rooted!";
    private final String expireText = "\u00a77[\u00a72Skill\u00a77] Root faded from $1!";

    public RootEffect(Skill skill, long duration) {
        super(skill, "Root", duration);
        this.types.add(EffectType.DISPELLABLE);
        this.types.add(EffectType.ROOT);
        this.types.add(EffectType.HARMFUL);
        int effectDuration = (int)duration / 1000 * 20;
        this.addMobEffect(2, effectDuration, 3, false);
        this.addMobEffect(8, effectDuration, -3, false);
    }

    @Override
    public void applyToMonster(Monster monster) {
        super.applyToMonster(monster);
        this.broadcast(monster.getEntity().getLocation(), "\u00a77[\u00a72Skill\u00a77] $1 was rooted!", Messaging.getLivingEntityName(monster));
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), "\u00a77[\u00a72Skill\u00a77] $1 was rooted!", player.getDisplayName());
    }

    @Override
    public void removeFromMonster(Monster monster) {
        super.removeFromMonster(monster);
        this.broadcast(monster.getEntity().getLocation(), "\u00a77[\u00a72Skill\u00a77] Root faded from $1!", Messaging.getLivingEntityName(monster));
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), "\u00a77[\u00a72Skill\u00a77] Root faded from $1!", player.getDisplayName());
    }
}

