/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class SafeFallEffect
extends ExpirableEffect {
    private final String applyText = "\u00a77[\u00a72Skill\u00a77] $1 has braced for landing!";
    private final String expireText = "\u00a77[\u00a72Skill\u00a77] $1 has lost safefall!";

    public SafeFallEffect(Skill skill, String name, long duration) {
        super(skill, name, duration);
        this.types.add(EffectType.DISPELLABLE);
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.SAFEFALL);
        this.types.add(EffectType.MAGIC);
    }

    public SafeFallEffect(Skill skill, long duration) {
        this(skill, "Safefall", duration);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), "\u00a77[\u00a72Skill\u00a77] $1 has braced for landing!", player.getDisplayName());
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), "\u00a77[\u00a72Skill\u00a77] $1 has lost safefall!", player.getDisplayName());
    }
}

