/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.DelayedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillType;

public class SilenceEffect
extends ExpirableEffect {
    private final String expireText = "\u00a77[\u00a72Skill\u00a77] $1 is no longer silenced!";

    public SilenceEffect(Skill skill, long duration) {
        super(skill, "Silence", duration);
        this.types.add(EffectType.DISPELLABLE);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.SILENCE);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        DelayedSkill dSkill = hero.getDelayedSkill();
        if (dSkill != null && dSkill.getSkill().isType(SkillType.SILENCABLE)) {
            hero.cancelDelayedSkill();
        }
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        this.broadcast(hero.getPlayer().getLocation(), "\u00a77[\u00a72Skill\u00a77] $1 is no longer silenced!", hero.getPlayer().getDisplayName());
    }
}

