/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SneakEffect
extends PeriodicExpirableEffect {
    private boolean vanillaSneaking;

    public SneakEffect(Skill skill, long period, long duration) {
        super(skill, "Sneak", period, duration);
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.PHYSICAL);
        this.types.add(EffectType.SNEAK);
        this.setVanillaSneaking(false);
    }

    public SneakEffect(Skill skill, long period, long duration, boolean vanillaSneaking) {
        super(skill, "Sneak", period, duration);
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.PHYSICAL);
        this.types.add(EffectType.SNEAK);
        this.setVanillaSneaking(vanillaSneaking);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        player.setSneaking(true);
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        player.setSneaking(false);
        Messaging.send((CommandSender)player, "\u00a77[\u00a72Skill\u00a77] You are no longer sneaking!", new Object[0]);
    }

    @Override
    public void tickHero(Hero hero) {
        hero.getPlayer().setSneaking(false);
        hero.getPlayer().setSneaking(true);
    }

    @Override
    public void tickMonster(Monster monster) {
    }

    public boolean isVanillaSneaking() {
        return this.vanillaSneaking;
    }

    public void setVanillaSneaking(boolean vanillaSneaking) {
        this.vanillaSneaking = vanillaSneaking;
    }
}

