/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.PeriodicEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.Sound;

public class SoundEffect
extends PeriodicEffect {
    public final Song song;
    public int songPosition = -1;
    public int songBeat = -1;

    public SoundEffect(Skill skill, String name, long period, Song song) {
        super(skill, name, period);
        this.song = song;
    }

    @Override
    public void tickMonster(Monster monster) {
        this.playNextNote(monster);
    }

    @Override
    public void tickHero(Hero hero) {
        this.playNextNote(hero);
    }

    public void playNextNote(CharacterTemplate template) {
        if (!this.song.hasNextNote(this.songPosition)) {
            template.removeEffect(this);
            return;
        }
        ++this.songBeat;
        while (this.song.hasNextNote(this.songPosition) && this.songBeat == this.song.getNote(this.songPosition + 1).beat) {
            ++this.songPosition;
            Note note = this.song.getNote(this.songPosition);
            template.getEntity().getWorld().playSound(template.getEntity().getLocation(), note.sound, note.volume, note.pitch);
        }
    }

    public static class Song {
        private final Note[] notes;

        public Song(Note ... notes) {
            this.notes = notes;
        }

        public boolean hasNextNote(int currentPosition) {
            return currentPosition < this.notes.length - 1;
        }

        public Note getNote(int currentPosition) {
            return this.notes[currentPosition];
        }
    }

    public static class Note {
        private final Sound sound;
        private final float volume;
        private final float pitch;
        private final int beat;

        public Note(Sound sound, float volume, float pitch, int position) {
            this.sound = sound;
            this.volume = volume;
            this.pitch = pitch;
            this.beat = position;
        }
    }
}

