/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class StunEffect
extends PeriodicExpirableEffect {
    private static final long period = 100L;
    private final String stunApplyText = "\u00a77[\u00a72Skill\u00a77] $1 is stunned!";
    private final String stunExpireText = "\u00a77[\u00a72Skill\u00a77] $1 is no longer stunned!";
    private Location loc;

    public StunEffect(Skill skill, long duration) {
        super(skill, "Stun", 100L, duration);
        this.types.add(EffectType.STUN);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.PHYSICAL);
        this.types.add(EffectType.DISABLE);
        this.addMobEffect(9, (int)(duration / 1000L) * 20, 127, false);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        this.loc = hero.getPlayer().getLocation();
        this.broadcast(player.getLocation(), "\u00a77[\u00a72Skill\u00a77] $1 is stunned!", player.getDisplayName());
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), "\u00a77[\u00a72Skill\u00a77] $1 is no longer stunned!", player.getDisplayName());
    }

    @Override
    public void tickHero(Hero hero) {
        Location location = hero.getPlayer().getLocation();
        if (location == null) {
            return;
        }
        if (location.getX() != this.loc.getX() || location.getY() != this.loc.getY() || location.getZ() != this.loc.getZ()) {
            this.loc.setYaw(location.getYaw());
            this.loc.setPitch(location.getPitch());
            hero.getPlayer().teleport(this.loc);
        }
    }

    @Override
    public void tickMonster(Monster monster) {
    }
}

