/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.effects.PeriodicEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.LivingEntity;

public class SummonEffect
extends ExpirableEffect {
    private final Hero summoner;
    private final String expireText;

    public SummonEffect(Skill skill, long duration, Hero summoner, String expireText) {
        super(skill, "Summon", duration);
        this.summoner = summoner;
        this.expireText = expireText;
        this.types.add(EffectType.DISPELLABLE);
        this.types.add(EffectType.BENEFICIAL);
    }

    @Override
    public void applyToMonster(Monster monster) {
        super.applyToMonster(monster);
        this.summoner.getSummons().add(monster);
        FollowEffect fEffect = new FollowEffect(this.skill, 1500L);
        this.summoner.addEffect(fEffect);
    }

    @Override
    public void removeFromMonster(Monster monster) {
        super.removeFromMonster(monster);
        this.summoner.getSummons().remove(monster);
        LivingEntity creature = monster.getEntity();
        this.broadcast(creature.getLocation(), this.expireText, new Object[0]);
        if (!creature.getWorld().getChunkAt(creature.getLocation()).isLoaded()) {
            creature.getWorld().loadChunk(creature.getWorld().getChunkAt(creature.getLocation()));
        }
        creature.remove();
        for (Monster mon : this.summoner.getSummons()) {
            if (!mon.hasEffect(this.name)) continue;
            return;
        }
        this.summoner.removeEffect(this.summoner.getEffect("Follow"));
    }

    public Hero getSummoner() {
        return this.summoner;
    }

    public class FollowEffect
    extends PeriodicEffect {
        public FollowEffect(Skill skill, long period) {
            super(skill, "Follow", period);
            this.setPersistent(true);
        }

        @Override
        public void applyToHero(Hero hero) {
            super.applyToHero(hero);
        }

        @Override
        public void removeFromHero(Hero hero) {
            super.removeFromHero(hero);
        }

        @Override
        public void tickHero(Hero hero) {
            super.tickHero(hero);
            for (Monster monster : hero.getSummons()) {
                Creature creature;
                if (!monster.hasEffect("Summon") || (creature = (Creature)monster.getEntity()).getTarget() != null && creature.getTarget() instanceof LivingEntity) continue;
                this.follow(creature, hero);
            }
        }

        private void follow(Creature creature, Hero hero) {
            Location creatureLoc = creature.getLocation();
            Location heroLoc = hero.getPlayer().getLocation();
            if (!creatureLoc.getWorld().equals(heroLoc.getWorld()) || creatureLoc.distanceSquared(heroLoc) > 400.0) {
                creature.teleport(heroLoc);
                return;
            }
        }
    }
}

