/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class WaterBreatheEffect
extends ExpirableEffect {
    private final String applyText;
    private final String expireText;

    public WaterBreatheEffect(Skill skill, long duration, String applyText, String expireText) {
        super(skill, "WaterBreathing", duration);
        this.applyText = applyText;
        this.expireText = expireText;
        this.addMobEffect(13, (int)(duration / 1000L) * 20, 0, false);
        this.types.add(EffectType.DISPELLABLE);
        this.types.add(EffectType.BENEFICIAL);
        this.types.add(EffectType.MAGIC);
        this.types.add(EffectType.WATER_BREATHING);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), this.applyText, player.getDisplayName());
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), this.expireText, player.getDisplayName());
    }
}

