/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.effects.common;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.ExpirableEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import org.bukkit.entity.Player;

public class WeaknessEffect
extends ExpirableEffect {
    private final String applyText;
    private final String expireText;

    public WeaknessEffect(Skill skill, long duration, String applyText, String expireText) {
        super(skill, "Weakness", duration);
        this.applyText = applyText;
        this.expireText = expireText;
        this.types.add(EffectType.DISPELLABLE);
        this.types.add(EffectType.HARMFUL);
        this.types.add(EffectType.WEAKNESS);
        this.addMobEffect(18, (int)(duration / 1000L * 20L), 1, false);
    }

    @Override
    public void applyToHero(Hero hero) {
        super.applyToHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), this.applyText, player.getDisplayName());
    }

    @Override
    public void removeFromHero(Hero hero) {
        super.removeFromHero(hero);
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), this.expireText, player.getDisplayName());
    }
}

