/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.party;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.party.PartyChannelManager;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HeroParty {
    private Hero leader;
    private final Set<Hero> members = new HashSet<Hero>();
    private Boolean noPvp = true;
    private final LinkedList<String> invites = new LinkedList();
    private boolean herochat = Heroes.herochat != null;
    private PartyChannelManager channelManager;

    public HeroParty(Hero leader, Heroes plugin) {
        this.leader = leader;
        this.members.add(leader);
        leader.setParty(this);
        this.channelManager = plugin.getPartyChannelManager();
        if (this.channelManager != null) {
            this.channelManager.makeNewPartyChannel(this);
        }
    }

    public void addInvite(String player) {
        this.invites.add(player);
    }

    public void addMember(Hero hero) {
        if (this.members.size() == Heroes.properties.maxPartySize) {
            return;
        }
        this.members.add(hero);
        if (this.herochat) {
            this.channelManager.addMember(this, hero);
        }
        this.update();
    }

    public int getInviteCount() {
        return this.invites.size();
    }

    public Hero getLeader() {
        return this.leader;
    }

    public Set<Hero> getMembers() {
        return new HashSet<Hero>(this.members);
    }

    public boolean isInvited(String player) {
        return this.invites.contains(player);
    }

    public Boolean isNoPvp() {
        return this.noPvp;
    }

    public boolean isPartyMember(Hero hero) {
        return this.members.contains(hero);
    }

    public boolean isPartyMember(Player player) {
        for (Hero hero : this.members) {
            if (!hero.getPlayer().equals(player)) continue;
            return true;
        }
        return false;
    }

    public void messageParty(String msg, Object ... params) {
        if (this.herochat) {
            this.channelManager.messageParty(this, msg, params);
        } else {
            for (Hero hero : this.members) {
                Messaging.send((CommandSender)hero.getPlayer(), msg, params);
            }
        }
    }

    public void pvpToggle() {
        if (this.noPvp.booleanValue()) {
            this.noPvp = false;
            this.messageParty("PvP is now enabled!", new Object[0]);
        } else {
            this.noPvp = true;
            this.messageParty("PvP is now disabled!", new Object[0]);
        }
    }

    public void removeInvite(Player player) {
        this.invites.remove(player.getName());
    }

    public void removeMember(Hero hero) {
        this.members.remove(hero);
        hero.setParty(null);
        if (this.herochat) {
            this.channelManager.removeMember(this, hero);
        }
        if (this.members.size() == 1) {
            Hero remainingMember = this.members.iterator().next();
            if (this.herochat) {
                this.channelManager.removeChannel(this, remainingMember);
            }
            remainingMember.setParty(null);
            this.messageParty("Party disbanded.", new Object[0]);
            this.members.remove(remainingMember);
            this.leader = null;
            return;
        }
        if (hero.equals(this.leader) && !this.members.isEmpty()) {
            this.setLeader(this.members.iterator().next());
        }
        this.update();
    }

    public void removeOldestInvite() {
        this.invites.pop();
    }

    public void setLeader(Hero leader) {
        this.leader = leader;
        if (this.herochat) {
            this.channelManager.makeNewPartyChannel(this);
        }
        this.messageParty("$1 is now leading the party.", leader.getPlayer().getDisplayName());
    }

    public void update() {
    }

    public void gainExp(double amount, HeroClass.ExperienceType type, Location location) {
        double bonusExp;
        HashSet<Hero> inRangeMembers = new HashSet<Hero>();
        for (Hero partyMember : this.members) {
            if (!location.getWorld().equals(partyMember.getPlayer().getLocation().getWorld()) || location.distanceSquared(partyMember.getPlayer().getLocation()) > 2500.0 || !partyMember.canGain(type)) continue;
            inRangeMembers.add(partyMember);
        }
        int partySize = inRangeMembers.size();
        double sharedExp = amount / (double)partySize;
        double d = bonusExp = partySize > 1 ? sharedExp : 0.0;
        if (partySize > 1) {
            bonusExp *= Properties.partyMults[partySize - 1];
        }
        bonusExp *= Heroes.properties.partyBonus;
        bonusExp = Util.formatDouble(bonusExp);
        for (Hero partyMember : inRangeMembers) {
            partyMember.gainExp(sharedExp + bonusExp, type, location);
        }
    }
}

