/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.party;

import com.dthielke.herochat.Channel;
import com.dthielke.herochat.Chatter;
import com.dthielke.herochat.Herochat;
import com.dthielke.herochat.MessageFormatSupplier;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.party.PartyChannel;
import com.herocraftonline.heroes.util.Messaging;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PartyChannelManager {
    private Map<HeroParty, PartyChannel> channels = new HashMap<HeroParty, PartyChannel>();

    public void makeNewPartyChannel(HeroParty party) {
        if (party.getLeader() == null) {
            return;
        }
        Chatter chatLeader = Herochat.getChatterManager().getChatter(party.getLeader().getPlayer());
        PartyChannel channel = new PartyChannel((MessageFormatSupplier)Herochat.getChannelManager(), chatLeader, new Chatter[0]);
        for (Hero hero : party.getMembers()) {
            Chatter chatter = Herochat.getChatterManager().getChatter(hero.getPlayer());
            chatter.addChannel((Channel)channel, false, false);
        }
        if (this.channels.containsKey(party)) {
            this.swapChannels(party, this.channels.get(party), channel);
        }
        this.channels.put(party, channel);
        Herochat.getChannelManager().addChannel((Channel)channel);
    }

    public PartyChannel getChannel(HeroParty party) {
        PartyChannel channel = this.channels.get(party);
        return channel;
    }

    public void addMember(HeroParty party, Hero hero) {
        PartyChannel channel = this.channels.get(party);
        if (channel == null) {
            return;
        }
        Chatter chatter = Herochat.getChatterManager().getChatter(hero.getPlayer());
        channel.addMember(chatter, false, true);
    }

    public void removeMember(HeroParty party, Hero hero) {
        PartyChannel channel = this.channels.get(party);
        if (channel == null) {
            return;
        }
        Chatter chatter = Herochat.getChatterManager().getChatter(hero.getPlayer());
        channel.removeMember(chatter, false, true);
    }

    public void messageParty(HeroParty party, String message, Object ... params) {
        PartyChannel channel = this.channels.get(party);
        if (channel == null) {
            return;
        }
        channel.announce(Messaging.parameterizeMessage(message, params));
    }

    protected void removeChannel(HeroParty party, Hero remainingMember) {
        PartyChannel channel = this.channels.get(party);
        if (channel == null) {
            return;
        }
        Chatter lastChatter = Herochat.getChatterManager().getChatter(remainingMember.getPlayer());
        channel.removeMember(lastChatter, false, true);
        lastChatter.removeChannel((Channel)channel, false, true);
        Herochat.getChannelManager().removeChannel((Channel)channel);
        this.channels.remove(party);
    }

    public void removeChannel(HeroParty party) {
        PartyChannel channel = this.channels.get(party);
        if (channel == null) {
            return;
        }
        Herochat.getChannelManager().removeChannel((Channel)channel);
        this.channels.remove(party);
    }

    public void setChannel(HeroParty party, PartyChannel channel) {
        PartyChannel oldChannel = this.channels.get(party);
        this.swapChannels(party, oldChannel, channel);
    }

    private boolean swapChannels(HeroParty party, PartyChannel oldChannel, PartyChannel newChannel) {
        if (oldChannel == null) {
            Herochat.getChannelManager().addChannel((Channel)newChannel);
            return this.checkPartyChannelMembers(party, newChannel);
        }
        Map<Chatter, Boolean> partyMap = this.getPartyMemberFocusedPartyChannel(oldChannel);
        Herochat.getChannelManager().addChannel((Channel)newChannel);
        this.checkPartyChannelMembers(party, newChannel);
        for (Chatter chatter : partyMap.keySet()) {
            newChannel.addMember(chatter, false, true);
            if (!partyMap.get(chatter).booleanValue()) continue;
            chatter.setActiveChannel((Channel)newChannel, false, true);
        }
        for (Chatter member : oldChannel.getMembers()) {
            member.removeChannel((Channel)oldChannel, false, true);
            oldChannel.removeMember(member, false, true);
        }
        Herochat.getChannelManager().removeChannel((Channel)oldChannel);
        return true;
    }

    private Map<Chatter, Boolean> getPartyMemberFocusedPartyChannel(PartyChannel partyChannel) {
        HashMap<Chatter, Boolean> chatterMap = new HashMap<Chatter, Boolean>();
        for (Chatter chatter : partyChannel.getMembers()) {
            if (chatter.getActiveChannel() != null && chatter.getActiveChannel().equals((Object)partyChannel)) {
                chatterMap.put(chatter, Boolean.TRUE);
                continue;
            }
            chatterMap.put(chatter, Boolean.FALSE);
        }
        return chatterMap;
    }

    private boolean checkPartyChannelMembers(HeroParty party, PartyChannel channel) {
        Set channelMembers = channel.getMembers();
        HashSet<Chatter> partyMembers = new HashSet<Chatter>();
        for (Hero hero : party.getMembers()) {
            partyMembers.add(Herochat.getChatterManager().getChatter(hero.getPlayer()));
        }
        if (!channelMembers.containsAll(partyMembers)) {
            for (Chatter memberChatter : partyMembers) {
                channel.addMember(memberChatter, false, true);
            }
            if (!channelMembers.containsAll(partyMembers)) {
                return false;
            }
        }
        if (!this.channels.containsKey(party) || !this.channels.get(party).equals((Object)channel)) {
            this.channels.put(party, channel);
        }
        return true;
    }
}

