/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.api.events.SkillCompleteEvent;
import com.herocraftonline.heroes.api.events.SkillUseEvent;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.common.SlowEffect;
import com.herocraftonline.heroes.characters.skill.DelayedSkill;
import com.herocraftonline.heroes.characters.skill.DelayedTargettedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.TargettedSkill;
import com.herocraftonline.heroes.util.Messaging;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public abstract class ActiveSkill
extends Skill {
    private String useText;
    private String delayText;
    private final boolean awardExpOnCast = true;

    public ActiveSkill(Heroes plugin, String name) {
        super(plugin, name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Long expiry;
        if (!(sender instanceof Player)) {
            return false;
        }
        String name = this.getName();
        Player player = (Player)sender;
        CharacterManager hm = this.plugin.getCharacterManager();
        Hero hero = hm.getHero(player);
        if (hero == null) {
            Messaging.send((CommandSender)player, "You are not a hero.", new Object[0]);
            return false;
        }
        HeroClass heroClass = hero.getHeroClass();
        HeroClass secondClass = hero.getSecondClass();
        if (!(heroClass.hasSkill(name) || secondClass != null && secondClass.hasSkill(name))) {
            Messaging.send((CommandSender)player, "Your classes don't have the skill: $1.", name);
            return true;
        }
        int level = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.LEVEL, 1, true);
        if (hero.getSkillLevel(this) < level) {
            this.messageAndEvent(hero, new SkillResult(SkillResult.ResultType.LOW_LEVEL, true, level));
            return true;
        }
        long time = System.currentTimeMillis();
        Long global = hero.getCooldown("global");
        if (hero.getDelayedSkill() == null && global != null && time < global) {
            String timeRemaining = String.format("%.1f", Float.valueOf((float)(global - time) / 1000.0f));
            this.messageAndEvent(hero, new SkillResult(SkillResult.ResultType.ON_GLOBAL_COOLDOWN, true, timeRemaining));
            return true;
        }
        int skillLevel = hero.getSkillLevel(this);
        int cooldown = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.COOLDOWN, 0, true);
        double coolReduce = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.COOLDOWN_REDUCE, 0.0, false) * (double)skillLevel;
        if ((cooldown -= (int)coolReduce) > 0 && (expiry = hero.getCooldown(name)) != null && time < expiry) {
            long remaining = expiry - time;
            String timeRemaining = String.format("%.1f", Float.valueOf((float)remaining / 1000.0f));
            this.messageAndEvent(hero, new SkillResult(SkillResult.ResultType.ON_COOLDOWN, true, name, timeRemaining));
            return false;
        }
        int delay = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.DELAY, 0, true);
        if (hero.isInCombat() && SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.NO_COMBAT_USE, false)) {
            DelayedSkill dSkill;
            if (delay > 0 && (dSkill = hero.getDelayedSkill()) != null && dSkill.getSkill().equals(this)) {
                hero.cancelDelayedSkill();
                hero.removeEffect(hero.getEffect("Casting"));
                this.broadcast(player.getLocation(), "\u00a77[\u00a72Skill\u00a77] $1 stopped using $2!", player.getDisplayName(), dSkill.getSkill().getName());
            }
            this.messageAndEvent(hero, SkillResult.NO_COMBAT);
            return true;
        }
        int manaCost = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MANA, 0, true);
        double manaReduce = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MANA_REDUCE, 0.0, false) * (double)skillLevel;
        manaCost -= (int)manaReduce;
        ItemStack itemStack = this.getReagentCost(hero);
        double healthCost = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.HEALTH_COST, 0, true);
        double healthReduce = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.HEALTH_COST_REDUCE, 0.0, false) * (double)skillLevel;
        int staminaCost = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.STAMINA, 0, true);
        double stamReduce = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.STAMINA_REDUCE, 0.0, false) * (double)skillLevel;
        SkillUseEvent skillEvent = new SkillUseEvent((Skill)this, player, hero, manaCost, healthCost -= healthReduce, staminaCost -= (int)stamReduce, itemStack, args);
        this.plugin.getServer().getPluginManager().callEvent((Event)skillEvent);
        if (skillEvent.isCancelled()) {
            this.messageAndEvent(hero, SkillResult.CANCELLED);
            return true;
        }
        boolean cancelDelayedSkillOnFailure = false;
        DelayedSkill dSkill = hero.getDelayedSkill();
        if (dSkill != null && dSkill.getSkill().equals(this)) {
            cancelDelayedSkillOnFailure = true;
        }
        if ((manaCost = skillEvent.getManaCost()) > hero.getMana()) {
            if (cancelDelayedSkillOnFailure) {
                hero.cancelDelayedSkill();
            }
            this.messageAndEvent(hero, SkillResult.LOW_MANA);
            return true;
        }
        healthCost = skillEvent.getHealthCost();
        if (healthCost > 0.0 && hero.getPlayer().getHealth() <= healthCost) {
            if (cancelDelayedSkillOnFailure) {
                hero.cancelDelayedSkill();
            }
            this.messageAndEvent(hero, SkillResult.LOW_HEALTH);
            return true;
        }
        staminaCost = skillEvent.getStaminaCost();
        if (staminaCost > 0 && hero.getPlayer().getFoodLevel() < staminaCost) {
            if (cancelDelayedSkillOnFailure) {
                hero.cancelDelayedSkill();
            }
            this.messageAndEvent(hero, SkillResult.LOW_STAMINA);
            return true;
        }
        itemStack = skillEvent.getReagentCost();
        if (itemStack != null && itemStack.getAmount() != 0 && !this.hasReagentCost(player, itemStack)) {
            if (cancelDelayedSkillOnFailure) {
                hero.cancelDelayedSkill();
            }
            String reagentName = itemStack.getType().name().toLowerCase().replace("_", " ");
            this.messageAndEvent(hero, new SkillResult(SkillResult.ResultType.MISSING_REAGENT, true, String.valueOf(itemStack.getAmount()), reagentName));
            return true;
        }
        int globalCD = Heroes.properties.globalCooldown;
        dSkill = null;
        if (delay > 0 && hero.getDelayedSkill() == null) {
            if (!this.addDelayedSkill(hero, delay, identifier, args)) return true;
            this.onWarmup(hero);
            if (cooldown < globalCD) {
                if (cooldown < globalCD && cooldown < 500) {
                    cooldown = 500;
                }
                hero.setCooldown("global", (long)cooldown + time);
            } else {
                hero.setCooldown("global", (long)globalCD + time);
            }
            this.messageAndEvent(hero, SkillResult.START_DELAY);
            if (!Heroes.properties.slowCasting || hero.hasEffectType(EffectType.SLOW)) return true;
            hero.addEffect(new SlowEffect((Skill)this, "Casting", delay, 3, false, "", "", hero));
            return true;
        }
        if (hero.getDelayedSkill() != null) {
            dSkill = hero.getDelayedSkill();
            if (!dSkill.getSkill().equals(this)) return false;
            if (!dSkill.isReady()) return true;
            hero.removeEffect(hero.getEffect("Casting"));
            hm.cancelDelayedSkill(dSkill);
        }
        SkillResult skillResult = dSkill instanceof DelayedTargettedSkill ? ((TargettedSkill)this).useDelayed(hero, ((DelayedTargettedSkill)dSkill).getTarget(), args) : this.use(hero, args);
        if (skillResult.type == SkillResult.ResultType.NORMAL) {
            time = System.currentTimeMillis();
            if (cooldown > 0) {
                hero.setCooldown(name, time + (long)cooldown);
                if (Heroes.properties.debug) {
                    Heroes.debugLog(Level.INFO, hero.getName() + " used skill: " + this.getName() + " cooldown until: " + time + cooldown);
                }
            }
            if (globalCD > 0 && !(dSkill instanceof DelayedSkill)) {
                if (cooldown < globalCD) {
                    if (cooldown < 100) {
                        cooldown = 100;
                    }
                    hero.setCooldown("global", (long)cooldown + time);
                } else {
                    hero.setCooldown("global", (long)globalCD + time);
                }
            }
            this.getClass();
            this.awardExp(hero);
            hero.setMana(hero.getMana() - manaCost);
            if (hero.isVerbose() && manaCost > 0) {
                Messaging.send((CommandSender)hero.getPlayer(), ChatColor.BLUE + "MANA " + Messaging.createManaBar(hero.getMana(), hero.getMaxMana()), new Object[0]);
            }
            if (healthCost > 0.0) {
                player.setHealth(player.getHealth() - healthCost);
            }
            if (staminaCost > 0) {
                player.setFoodLevel(player.getFoodLevel() - staminaCost);
            }
            if (itemStack != null && itemStack.getAmount() > 0) {
                player.getInventory().removeItem(new ItemStack[]{itemStack});
                player.updateInventory();
            }
        }
        this.messageAndEvent(hero, skillResult);
        return true;
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection section = super.getDefaultConfig();
        section.set(SkillSetting.USE_TEXT.node(), (Object)"\u00a77[\u00a72Skill\u00a77] %hero% used %skill%!");
        return section;
    }

    protected boolean addDelayedSkill(Hero hero, int delay, String identifier, String[] args) {
        Player player = hero.getPlayer();
        DelayedSkill dSkill = new DelayedSkill(identifier, hero, delay, this, args);
        this.broadcast(player.getLocation(), this.delayText, player.getDisplayName(), this.getName());
        this.plugin.getCharacterManager().queueDelayedSkill(dSkill);
        hero.setDelayedSkill(dSkill);
        return true;
    }

    public String getDelayText() {
        return this.delayText;
    }

    public String getUseText() {
        return this.useText;
    }

    @Override
    public void init() {
        String delayText = SkillConfigManager.getRaw((Skill)this, SkillSetting.DELAY_TEXT, "\u00a77[\u00a72Skill\u00a77] %hero% begins to use %skill%!");
        delayText = delayText.replace("%hero%", "$1").replace("%skill%", "$2");
        this.setDelayText(delayText);
        String useText = SkillConfigManager.getRaw((Skill)this, SkillSetting.USE_TEXT, "\u00a77[\u00a72Skill\u00a77] %hero% used %skill%!");
        useText = useText.replace("%hero%", "$1").replace("%skill%", "$2");
        this.setUseText(useText);
    }

    public void setDelayText(String delayText) {
        this.delayText = delayText;
    }

    public void setUseText(String useText) {
        this.useText = useText;
    }

    public abstract SkillResult use(Hero var1, String[] var2);

    private void awardExp(Hero hero) {
        if (hero.canGain(HeroClass.ExperienceType.SKILL)) {
            hero.gainExp(SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.EXP, 0, false), HeroClass.ExperienceType.SKILL, hero.getViewingLocation(1.0));
        }
    }

    protected void broadcastExecuteText(Hero hero) {
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), this.getUseText(), player.getDisplayName(), this.getName());
    }

    private void messageAndEvent(Hero hero, SkillResult sr) {
        Player player = hero.getPlayer();
        if (sr.showMessage) {
            switch (sr.type) {
                case INVALID_TARGET: {
                    Messaging.send((CommandSender)player, "\u00a77[\u00a72Skill\u00a77] Invalid Target!", new Object[0]);
                    break;
                }
                case LOW_HEALTH: {
                    Messaging.send((CommandSender)player, "\u00a77[\u00a72Skill\u00a77] Not enough health!", new Object[0]);
                    break;
                }
                case LOW_LEVEL: {
                    Messaging.send((CommandSender)player, "\u00a77[\u00a72Skill\u00a77] You must be level $1 to do that.", sr.args[0]);
                    break;
                }
                case LOW_MANA: {
                    Messaging.send((CommandSender)player, "\u00a77[\u00a72Skill\u00a77] Not enough mana!", new Object[0]);
                    break;
                }
                case LOW_STAMINA: {
                    Messaging.send((CommandSender)player, "\u00a77[\u00a72Skill\u00a77] You are too fatigued!", new Object[0]);
                    break;
                }
                case ON_COOLDOWN: {
                    Messaging.send((CommandSender)hero.getPlayer(), "\u00a77[\u00a72Skill\u00a77] $1 has $2s until recovery!", sr.args[0], sr.args[1]);
                    break;
                }
                case ON_GLOBAL_COOLDOWN: {
                    Messaging.send((CommandSender)hero.getPlayer(), "\u00a77[\u00a72Skill\u00a77] You must wait $1s before using another skill.", sr.args[0]);
                    break;
                }
                case MISSING_REAGENT: {
                    Messaging.send((CommandSender)player, "\u00a77[\u00a72Skill\u00a77] You need to have $1 $2 to use $3!", sr.args[0], sr.args[1], this.getName());
                    break;
                }
                case NO_COMBAT: {
                    Messaging.send((CommandSender)player, "\u00a77[\u00a72Skill\u00a77] You may not use that skill in combat!", new Object[0]);
                    break;
                }
                case SKIP_POST_USAGE: {
                    return;
                }
            }
        }
        SkillCompleteEvent sce = new SkillCompleteEvent(hero, this, sr);
        this.plugin.getServer().getPluginManager().callEvent((Event)sce);
    }

    public void onWarmup(Hero hero) {
    }
}

