/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.api.events.HeroChangeLevelEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;

public class OutsourcedSkill
extends Skill {
    private String[] permissions;
    private Permission permission;

    public OutsourcedSkill(Heroes plugin, String name) {
        super(plugin, name);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new SkillHeroListener(), (Plugin)plugin);
    }

    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
        this.permission = this.plugin.getServer().getPluginManager().getPermission(this.getName());
        if (this.permission != null) {
            this.plugin.getServer().getPluginManager().removePermission(this.permission);
        }
        HashMap<String, Boolean> children = new HashMap<String, Boolean>();
        for (String s : permissions) {
            children.put(s, true);
        }
        this.permission = new Permission(this.getName(), "Permission-Skill " + this.getName(), children);
        this.plugin.getServer().getPluginManager().addPermission(this.permission);
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        return true;
    }

    @Override
    public void init() {
    }

    public void tryLearningSkill(Hero hero) {
        Player player = hero.getPlayer();
        String world = player.getWorld().getName();
        String playerName = player.getName();
        if (hero.getHeroClass().hasSkill(this.getName()) || hero.getSecondClass() != null && hero.getSecondClass().hasSkill(this.getName())) {
            if (hero.getSkillLevel(this) >= SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.LEVEL, 1, true)) {
                if (Heroes.perms.getName().equals("Permissions3")) {
                    for (String permission : this.permissions) {
                        if (Heroes.perms.has(world, playerName, permission)) continue;
                        Heroes.perms.playerAddTransient(player, permission);
                    }
                }
                Heroes.perms.playerAddTransient(player, this.permission.getName());
            } else {
                if (Heroes.perms.getName().equals("Permissions3")) {
                    for (String permission : this.permissions) {
                        if (!Heroes.perms.has(world, playerName, permission)) continue;
                        Heroes.perms.playerRemoveTransient(player, permission);
                    }
                }
                Heroes.perms.playerRemoveTransient(player, this.permission.getName());
            }
        } else {
            if (this.permissions == null) {
                Heroes.log(Level.SEVERE, "No permissions detected for skill: " + this.getName() + " fix your config!");
                return;
            }
            if (Heroes.perms.getName().equals("Permissions3")) {
                for (String permission : this.permissions) {
                    if (!Heroes.perms.has(world, playerName, permission)) continue;
                    Heroes.perms.playerRemoveTransient(player, permission);
                }
            }
            Heroes.perms.playerRemoveTransient(player, this.permission.getName());
        }
    }

    @Override
    public String getDescription(Hero hero) {
        return this.getDescription();
    }

    public class SkillHeroListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onClassChange(final ClassChangeEvent event) {
            if (event.isCancelled()) {
                return;
            }
            OutsourcedSkill.this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)OutsourcedSkill.this.plugin, new Runnable(){

                @Override
                public void run() {
                    OutsourcedSkill.this.tryLearningSkill(event.getHero());
                }
            }, 1L);
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onHeroChangeLevel(final HeroChangeLevelEvent event) {
            OutsourcedSkill.this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)OutsourcedSkill.this.plugin, new Runnable(){

                @Override
                public void run() {
                    OutsourcedSkill.this.tryLearningSkill(event.getHero());
                }
            }, 1L);
        }
    }
}

