/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.api.events.HeroChangeLevelEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class PassiveSkill
extends Skill {
    private String applyText = null;
    private String unapplyText = null;
    private EffectType[] effectTypes = null;

    public PassiveSkill(Heroes plugin, String name) {
        super(plugin, name);
        this.setUsage("Passive Skill");
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new SkillListener(), (Plugin)plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Messaging.send(sender, "$1 is a passive skill and cannot be used!", this.getName());
        return true;
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection section = super.getDefaultConfig();
        section.set(SkillSetting.APPLY_TEXT.node(), (Object)"%hero% gained %skill%!");
        section.set(SkillSetting.UNAPPLY_TEXT.node(), (Object)"%hero% lost %skill%!");
        return section;
    }

    @Override
    public void init() {
        this.applyText = SkillConfigManager.getRaw((Skill)this, SkillSetting.APPLY_TEXT, "");
        this.applyText = this.applyText.replace("%hero%", "$1").replace("%skill%", "$2");
        this.unapplyText = SkillConfigManager.getRaw((Skill)this, SkillSetting.UNAPPLY_TEXT, "");
        this.unapplyText = this.unapplyText.replace("%hero%", "$1").replace("%skill%", "$2");
    }

    public void setEffectTypes(EffectType ... effectTypes) {
        this.effectTypes = effectTypes;
    }

    public void tryApplying(Hero hero) {
        if (!hero.hasAccessToSkill(this)) {
            return;
        }
        if (hero.canUseSkill(this)) {
            if (!hero.hasEffect(this.getName())) {
                this.apply(hero);
            }
        } else {
            this.unapply(hero);
        }
    }

    protected void apply(Hero hero) {
        Effect effect = new Effect(this, this.getName(), this.effectTypes);
        effect.setPersistent(true);
        hero.addEffect(effect);
        Player player = hero.getPlayer();
        if (!Properties.silencePassiveSkills) {
            this.broadcast(player.getLocation(), this.applyText, player.getDisplayName(), this.getName());
        }
    }

    protected void unapply(Hero hero) {
        if (hero.hasEffect(this.getName())) {
            hero.removeEffect(hero.getEffect(this.getName()));
            Player player = hero.getPlayer();
            if (!Properties.silencePassiveSkills) {
                this.broadcast(player.getLocation(), this.unapplyText, player.getDisplayName(), this.getName());
            }
        }
    }

    public class SkillListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onClassChange(ClassChangeEvent event) {
            PassiveSkill.this.tryApplying(event.getHero());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onHeroChangeLevel(HeroChangeLevelEvent event) {
            PassiveSkill.this.tryApplying(event.getHero());
        }
    }
}

