/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.util.Messaging;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public abstract class Skill
extends BasicCommand {
    public final Heroes plugin;
    private final Configuration defaultConfig = new MemoryConfiguration();
    private final Set<SkillType> types = EnumSet.noneOf(SkillType.class);

    public Skill(Heroes plugin, String name) {
        super(name);
        this.plugin = plugin;
    }

    public abstract String getDescription(Hero var1);

    public void addSpellTarget(Entity o, Hero hero) {
        this.plugin.getDamageManager().addSpellTarget(o, hero, this);
    }

    public void broadcast(Location source, String message, Object ... args) {
        Player[] players;
        if (message == null || message.isEmpty() || message.equalsIgnoreCase("off")) {
            return;
        }
        for (Player player : players = this.plugin.getServer().getOnlinePlayers()) {
            Location playerLocation = player.getLocation();
            Hero hero = this.plugin.getCharacterManager().getHero(player);
            if (hero.isSuppressing(this) || !source.getWorld().equals(playerLocation.getWorld()) || !this.isInMsgRange(playerLocation, source)) continue;
            Messaging.send((CommandSender)player, message, args);
        }
    }

    public static boolean damageCheck(Player player, LivingEntity target) {
        if (player.equals(target)) {
            return false;
        }
        EntityDamageByEntityEvent damageEntityEvent = new EntityDamageByEntityEvent((Entity)player, (Entity)target, EntityDamageEvent.DamageCause.CUSTOM, 0.0);
        Bukkit.getServer().getPluginManager().callEvent((Event)damageEntityEvent);
        if (damageEntityEvent.isCancelled()) {
            return false;
        }
        damageEntityEvent = new EntityDamageByEntityEvent((Entity)target, (Entity)player, EntityDamageEvent.DamageCause.CUSTOM, 0.0);
        Bukkit.getServer().getPluginManager().callEvent((Event)damageEntityEvent);
        return !damageEntityEvent.isCancelled();
    }

    @Override
    public abstract boolean execute(CommandSender var1, String var2, String[] var3);

    public ConfigurationSection getDefaultConfig() {
        return this.defaultConfig;
    }

    public Set<SkillType> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public abstract void init();

    @Override
    public boolean isShownOnHelpMenu() {
        return false;
    }

    public boolean isType(SkillType type) {
        return this.types.contains((Object)type);
    }

    protected void setTypes(SkillType ... types) {
        this.types.addAll(Arrays.asList(types));
    }

    public static void knockBack(LivingEntity target, LivingEntity attacker, double damage) {
        NMSHandler.getInterface().knockBack(target, attacker, damage);
    }

    @Deprecated
    public boolean damageEntity(LivingEntity target, LivingEntity attacker, int damage) {
        return Skill.damageEntity(target, attacker, damage, this.isType(SkillType.PHYSICAL) ? EntityDamageEvent.DamageCause.ENTITY_ATTACK : EntityDamageEvent.DamageCause.MAGIC);
    }

    public boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage) {
        return Skill.damageEntity(target, attacker, damage, this.isType(SkillType.PHYSICAL) ? EntityDamageEvent.DamageCause.ENTITY_ATTACK : EntityDamageEvent.DamageCause.MAGIC);
    }

    @Deprecated
    public static boolean damageEntity(LivingEntity target, LivingEntity attacker, int damage, EntityDamageEvent.DamageCause cause, boolean knockback) {
        return Skill.damageEntity(target, attacker, Math.floor(damage), cause, knockback);
    }

    public static boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage, EntityDamageEvent.DamageCause cause, boolean knockback) {
        return NMSHandler.getInterface().damageEntity(target, attacker, damage, cause, knockback);
    }

    @Deprecated
    public static boolean damageEntity(LivingEntity target, LivingEntity attacker, int damage, EntityDamageEvent.DamageCause cause) {
        return Skill.damageEntity(target, attacker, (double)damage, cause, true);
    }

    public static boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage, EntityDamageEvent.DamageCause cause) {
        return Skill.damageEntity(target, attacker, damage, cause, true);
    }

    protected boolean hasReagentCost(Player player, ItemStack itemStack) {
        if (itemStack == null || itemStack.getAmount() == 0) {
            return true;
        }
        int amount = 0;
        for (ItemStack stack : player.getInventory().all(itemStack.getType()).values()) {
            if ((amount += stack.getAmount()) < itemStack.getAmount()) continue;
            return true;
        }
        return false;
    }

    protected ItemStack getReagentCost(Hero hero) {
        int reagentCost = SkillConfigManager.getUseSetting(hero, this, SkillSetting.REAGENT_COST, 0, true);
        String reagentName = SkillConfigManager.getUseSetting(hero, this, SkillSetting.REAGENT, (String)null);
        ItemStack itemStack = null;
        if (reagentCost > 0 && reagentName != null && !reagentName.isEmpty()) {
            String[] vals = reagentName.split(":");
            try {
                int id = Integer.parseInt(vals[0]);
                byte sub = 0;
                if (vals.length > 1) {
                    sub = (byte)Integer.parseInt(vals[1]);
                }
                itemStack = new ItemStack(id, reagentCost, (short)sub);
            }
            catch (NumberFormatException e) {
                Heroes.log(Level.SEVERE, "Invalid skill reagent defined in " + this.getName() + ". Please switch to new format ID:DAMAGE");
            }
        }
        return itemStack;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.toString().equals(this.getName())) {
            return true;
        }
        if (!(obj instanceof Skill)) {
            return false;
        }
        Skill s = (Skill)obj;
        return s.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private boolean isInMsgRange(Location loc1, Location loc2) {
        return Math.abs(loc1.getBlockX() - loc2.getBlockX()) < 25 && Math.abs(loc1.getBlockY() - loc2.getBlockY()) < 25 && Math.abs(loc1.getBlockZ() - loc2.getBlockZ()) < 25;
    }
}

