/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class SkillConfigManager {
    public static Configuration outsourcedSkillConfig;
    public static Configuration standardSkillConfig;
    public static Configuration defaultSkillConfig;
    public static File dataFolder;
    public static Map<String, Configuration> classSkillConfigs;
    public static File skillConfigFile;
    public static File outsourcedSkillConfigFile;

    public SkillConfigManager(Heroes plugin) {
        dataFolder = plugin.getDataFolder();
        skillConfigFile = new File(dataFolder, "skills.yml");
        outsourcedSkillConfigFile = new File(dataFolder, "permission-skills.yml");
        plugin.getConfigManager().checkForConfig(outsourcedSkillConfigFile);
    }

    public void reload() {
        standardSkillConfig = null;
        outsourcedSkillConfig = null;
        this.load();
    }

    public void load() {
        standardSkillConfig = YamlConfiguration.loadConfiguration((File)skillConfigFile);
        standardSkillConfig.setDefaults(defaultSkillConfig);
        standardSkillConfig.options().copyDefaults(true);
        outsourcedSkillConfig = YamlConfiguration.loadConfiguration((File)outsourcedSkillConfigFile);
        outsourcedSkillConfig.setDefaults(standardSkillConfig);
        for (String key : standardSkillConfig.getKeys(true)) {
            if (standardSkillConfig.isConfigurationSection(key)) continue;
            outsourcedSkillConfig.set(key, standardSkillConfig.get(key));
        }
    }

    public static void saveSkillConfig() {
        try {
            ((YamlConfiguration)standardSkillConfig).save(skillConfigFile);
        }
        catch (IOException e) {
            Heroes.log(Level.WARNING, "Unable to save default skills file!");
        }
    }

    public Configuration getClassConfig(String name) {
        return classSkillConfigs.get(name);
    }

    public void addClassSkillSettings(String className, String skillName, ConfigurationSection section) {
        Configuration config = classSkillConfigs.get(className);
        if (config == null) {
            config = new MemoryConfiguration();
            classSkillConfigs.put(className, config);
        }
        if (section == null) {
            return;
        }
        ConfigurationSection classSection = config.getConfigurationSection(skillName);
        if (classSection == null) {
            classSection = config.createSection(skillName);
        }
        for (String key : section.getKeys(true)) {
            if (!section.isConfigurationSection(key)) continue;
            classSection.createSection(key);
        }
        for (String key : section.getKeys(true)) {
            if (section.isConfigurationSection(key)) continue;
            classSection.set(key, section.get(key));
        }
    }

    public void loadSkillDefaults(Skill skill) {
        if (skill instanceof OutsourcedSkill) {
            return;
        }
        ConfigurationSection dSection = skill.getDefaultConfig();
        ConfigurationSection newSection = defaultSkillConfig.createSection(skill.getName());
        for (String key : dSection.getKeys(true)) {
            if (!dSection.isConfigurationSection(key)) continue;
            newSection.createSection(key);
        }
        for (String key : dSection.getKeys(true)) {
            if (dSection.isConfigurationSection(key)) continue;
            Object o = dSection.get(key);
            if (o instanceof List) {
                newSection.set(key, new ArrayList((List)o));
                continue;
            }
            newSection.set(key, o);
        }
    }

    public static void setClassDefaults() {
        for (Configuration config : classSkillConfigs.values()) {
            config.setDefaults(outsourcedSkillConfig);
        }
    }

    public static String getRaw(Skill skill, String setting, String def) {
        return outsourcedSkillConfig.getString(skill.getName() + "." + setting, def);
    }

    public static String getRaw(Skill skill, SkillSetting setting, String def) {
        return SkillConfigManager.getRaw(skill, setting.node(), def);
    }

    public static Boolean getRaw(Skill skill, SkillSetting setting, boolean def) {
        return SkillConfigManager.getRaw(skill, setting.node(), def);
    }

    public static Boolean getRaw(Skill skill, String setting, boolean def) {
        return Boolean.valueOf(outsourcedSkillConfig.getString(skill.getName() + "." + setting));
    }

    public static Set<String> getRawKeys(Skill skill, String setting) {
        String path = skill.getName();
        if (setting != null) {
            path = path + "." + setting;
        }
        if (!outsourcedSkillConfig.isConfigurationSection(path)) {
            return new HashSet<String>();
        }
        return outsourcedSkillConfig.getConfigurationSection(path).getKeys(false);
    }

    public static Object getSetting(HeroClass hc, Skill skill, String setting) {
        Configuration config = classSkillConfigs.get(hc.getName());
        if (config == null || !config.isConfigurationSection(skill.getName())) {
            return null;
        }
        return config.get(skill.getName() + "." + setting);
    }

    public static int getSetting(HeroClass hc, Skill skill, String setting, int def) {
        Object val = SkillConfigManager.getSetting(hc, skill, setting);
        if (val == null) {
            return def;
        }
        Integer i = Util.toInt(val);
        return i != null ? i : def;
    }

    public static double getSetting(HeroClass hc, Skill skill, String setting, double def) {
        Object val = SkillConfigManager.getSetting(hc, skill, setting);
        if (val == null) {
            return def;
        }
        Double d = Util.toDouble(val);
        return d != null ? d : def;
    }

    public static String getSetting(HeroClass hc, Skill skill, String setting, String def) {
        Object val = SkillConfigManager.getSetting(hc, skill, setting);
        if (val == null) {
            return def;
        }
        return val.toString();
    }

    public static Boolean getSetting(HeroClass hc, Skill skill, String setting, boolean def) {
        Object val = SkillConfigManager.getSetting(hc, skill, setting);
        if (val == null) {
            return null;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Boolean.valueOf((String)val);
        }
        return null;
    }

    public static List<String> getSetting(HeroClass hc, Skill skill, String setting, List<String> def) {
        Configuration config = classSkillConfigs.get(hc.getName());
        if (config == null || !config.isConfigurationSection(skill.getName())) {
            return def;
        }
        List val = config.getStringList(skill.getName() + "." + setting);
        return val != null && !val.isEmpty() ? val : def;
    }

    public static Set<String> getSettingKeys(HeroClass hc, Skill skill, String setting) {
        Configuration config;
        String path = skill.getName();
        if (setting != null) {
            path = path + "." + setting;
        }
        if ((config = classSkillConfigs.get(hc.getName())) == null || !config.isConfigurationSection(path)) {
            return new HashSet<String>();
        }
        return config.getConfigurationSection(path).getKeys(false);
    }

    public static Set<String> getUseSettingKeys(Hero hero, Skill skill, String setting) {
        ConfigurationSection section;
        HashSet<String> vals = new HashSet<String>();
        String path = skill.getName();
        if (setting != null) {
            path = path + "." + setting;
        }
        if ((section = outsourcedSkillConfig.getConfigurationSection(path)) != null) {
            vals.addAll(section.getKeys(false));
        }
        if (hero.canPrimaryUseSkill(skill)) {
            vals.addAll(SkillConfigManager.getSettingKeys(hero.getHeroClass(), skill, setting));
        }
        if (hero.canSecondUseSkill(skill)) {
            vals.addAll(SkillConfigManager.getSettingKeys(hero.getSecondClass(), skill, setting));
        }
        return vals;
    }

    public static List<String> getUseSettingKeys(Hero hero, Skill skill) {
        HashSet<String> keys = new HashSet<String>();
        ConfigurationSection section = outsourcedSkillConfig.getConfigurationSection(skill.getName());
        if (section != null) {
            keys.addAll(section.getKeys(false));
        }
        if (hero.canPrimaryUseSkill(skill)) {
            keys.addAll(SkillConfigManager.getSettingKeys(hero.getHeroClass(), skill, null));
        }
        if (hero.canSecondUseSkill(skill)) {
            keys.addAll(SkillConfigManager.getSettingKeys(hero.getSecondClass(), skill, null));
        }
        return new ArrayList<String>(keys);
    }

    public static int getLevel(Hero hero, Skill skill, int def) {
        String name = skill.getName();
        if (hero == null) {
            return outsourcedSkillConfig.getInt(name + "." + SkillSetting.LEVEL.node(), def);
        }
        int val1 = -1;
        int val2 = -1;
        if (hero.getHeroClass().hasSkill(name)) {
            val1 = SkillConfigManager.getSetting(hero.getHeroClass(), skill, SkillSetting.LEVEL.node(), def);
        }
        if (hero.getSecondClass() != null && hero.getSecondClass().hasSkill(name)) {
            val2 = SkillConfigManager.getSetting(hero.getSecondClass(), skill, SkillSetting.LEVEL.node(), def);
        }
        if (val1 != -1 && val2 != -1) {
            return val1 < val2 ? val1 : val2;
        }
        if (val1 != -1) {
            return val1;
        }
        if (val2 != -1) {
            return val2;
        }
        return outsourcedSkillConfig.getInt(name + "." + SkillSetting.LEVEL.node(), def);
    }

    public static int getUseSetting(Hero hero, Skill skill, SkillSetting setting, int def, boolean lower) {
        if (setting == SkillSetting.LEVEL) {
            return SkillConfigManager.getLevel(hero, skill, def);
        }
        return SkillConfigManager.getUseSetting(hero, skill, setting.node(), def, lower);
    }

    public static String getUseSetting(Hero hero, Skill skill, SkillSetting setting, String def) {
        return SkillConfigManager.getUseSetting(hero, skill, setting.node(), def);
    }

    public static double getUseSetting(Hero hero, Skill skill, SkillSetting setting, double def, boolean lower) {
        return SkillConfigManager.getUseSetting(hero, skill, setting.node(), def, lower);
    }

    public static boolean getUseSetting(Hero hero, Skill skill, SkillSetting setting, boolean def) {
        return SkillConfigManager.getUseSetting(hero, skill, setting.node(), def);
    }

    public static int getUseSetting(Hero hero, Skill skill, String setting, int def, boolean lower) {
        if (setting.equalsIgnoreCase("level")) {
            throw new IllegalArgumentException("Do not use getSetting() for grabbing a hero level!");
        }
        String name = skill.getName();
        if (hero == null) {
            return outsourcedSkillConfig.getInt(name + "." + setting, def);
        }
        int val1 = -1;
        int val2 = -1;
        if (hero.canPrimaryUseSkill(skill)) {
            val1 = SkillConfigManager.getSetting(hero.getHeroClass(), skill, setting, def);
        }
        if (hero.canSecondUseSkill(skill)) {
            val2 = SkillConfigManager.getSetting(hero.getSecondClass(), skill, setting, def);
        }
        if (val1 != -1 && val2 != -1) {
            if (lower) {
                return val1 < val2 ? val1 : val2;
            }
            return val1 > val2 ? val1 : val2;
        }
        if (val1 != -1) {
            return val1;
        }
        if (val2 != -1) {
            return val2;
        }
        return outsourcedSkillConfig.getInt(name + "." + setting, def);
    }

    public static double getUseSetting(Hero hero, Skill skill, String setting, double def, boolean lower) {
        String name = skill.getName();
        if (hero == null) {
            return outsourcedSkillConfig.getDouble(name + "." + setting, def);
        }
        double val1 = -1.0;
        double val2 = -1.0;
        if (hero.canPrimaryUseSkill(skill)) {
            val1 = SkillConfigManager.getSetting(hero.getHeroClass(), skill, setting, def);
        }
        if (hero.canSecondUseSkill(skill)) {
            val2 = SkillConfigManager.getSetting(hero.getSecondClass(), skill, setting, def);
        }
        if (val1 != -1.0 && val2 != -1.0) {
            if (lower) {
                return val1 < val2 ? val1 : val2;
            }
            return val1 > val2 ? val1 : val2;
        }
        if (val1 != -1.0) {
            return val1;
        }
        if (val2 != -1.0) {
            return val2;
        }
        return outsourcedSkillConfig.getDouble(name + "." + setting, def);
    }

    public static boolean getUseSetting(Hero hero, Skill skill, String setting, boolean def) {
        if (hero == null) {
            return outsourcedSkillConfig.getBoolean(skill.getName() + "." + setting, def);
        }
        Boolean val = null;
        if (hero.canPrimaryUseSkill(skill) && (val = SkillConfigManager.getSetting(hero.getHeroClass(), skill, setting, def)) != null) {
            return val;
        }
        if (hero.canSecondUseSkill(skill) && (val = SkillConfigManager.getSetting(hero.getHeroClass(), skill, setting, def)) != null) {
            return val;
        }
        return def;
    }

    public static String getUseSetting(Hero hero, Skill skill, String setting, String def) {
        if (hero == null) {
            return outsourcedSkillConfig.getString(skill.getName() + "." + setting, def);
        }
        if (hero.canPrimaryUseSkill(skill)) {
            return SkillConfigManager.getSetting(hero.getHeroClass(), skill, setting, def);
        }
        if (hero.canSecondUseSkill(skill)) {
            return SkillConfigManager.getSetting(hero.getSecondClass(), skill, setting, def);
        }
        return outsourcedSkillConfig.getString(skill.getName() + "." + setting, def);
    }

    public static List<String> getUseSetting(Hero hero, Skill skill, String setting, List<String> def) {
        List list;
        if (hero == null) {
            List list2 = outsourcedSkillConfig.getStringList(skill.getName() + "." + setting);
            return list2 != null ? list2 : def;
        }
        ArrayList<String> vals = new ArrayList<String>();
        if (hero.canPrimaryUseSkill(skill)) {
            list = SkillConfigManager.getSetting(hero.getHeroClass(), skill, setting, new ArrayList<String>());
            vals.addAll(list);
        }
        if (hero.canSecondUseSkill(skill)) {
            list = SkillConfigManager.getSetting(hero.getSecondClass(), skill, setting, new ArrayList<String>());
            vals.addAll(list);
        }
        if (!vals.isEmpty()) {
            return vals;
        }
        list = outsourcedSkillConfig.getStringList(skill.getName() + "." + setting);
        return list != null && !list.isEmpty() ? list : def;
    }

    static {
        defaultSkillConfig = new MemoryConfiguration();
        classSkillConfigs = new HashMap<String, Configuration>();
    }
}

