/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillRegistrar;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class SkillManager
extends URLClassLoader {
    private final Map<String, Skill> skills = new LinkedHashMap<String, Skill>();
    private final Map<String, Skill> identifiers = new HashMap<String, Skill>();
    private final Map<String, File> skillFiles = new HashMap<String, File>();
    private final Heroes plugin;
    private final File dir;
    private final URLClassLoader classLoader;

    public SkillManager(Heroes plugin) {
        super(((URLClassLoader)((Object)((Object)plugin)).getClass().getClassLoader()).getURLs(), ((Object)((Object)plugin)).getClass().getClassLoader());
        this.plugin = plugin;
        this.dir = new File(plugin.getDataFolder(), "skills");
        this.dir.mkdir();
        if (this.getClass().getConstructors().length > 1) {
            this.classLoader = null;
            return;
        }
        this.classLoader = new URLClassLoader(this.getURLs(), (ClassLoader)this);
        for (String skillFile : this.dir.list()) {
            if (!skillFile.contains(".jar")) continue;
            File file = new File(this.dir, skillFile);
            String name = skillFile.toLowerCase().replace(".jar", "").replace("skill", "");
            if (this.skillFiles.containsKey(name)) {
                Heroes.log(Level.SEVERE, "Duplicate skill jar found! Please remove " + skillFile + " or " + this.skillFiles.get(name).getName());
                continue;
            }
            this.skillFiles.put(name, file);
            try {
                this.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public void addSkill(Skill skill) {
        this.skills.put(skill.getName().toLowerCase().replace("skill", ""), skill);
        for (String ident : skill.getIdentifiers()) {
            this.identifiers.put(ident.toLowerCase(), skill);
        }
    }

    public Skill getSkill(String name) {
        if (name == null) {
            return null;
        }
        if (!this.isLoaded(name = name.toLowerCase()) && this.skillFiles.containsKey(name)) {
            this.loadSkill(name);
        }
        return this.skills.get(name);
    }

    public boolean loadOutsourcedSkill(String name) {
        if (name == null || this.skills.get(name.toLowerCase()) != null) {
            return true;
        }
        OutsourcedSkill oSkill = new OutsourcedSkill(this.plugin, name);
        ConfigurationSection config = SkillConfigManager.outsourcedSkillConfig.getConfigurationSection(oSkill.getName());
        List perms = new ArrayList();
        if (config != null) {
            perms = config.getStringList("permissions");
        }
        if (perms.isEmpty()) {
            Heroes.log(Level.SEVERE, "There are no permissions defined for " + oSkill.getName());
            return false;
        }
        oSkill.setPermissions(perms.toArray(new String[perms.size()]));
        oSkill.setUsage(config.getString("usage"));
        oSkill.setDescription(config.getString("usage"));
        this.skills.put(name.toLowerCase(), oSkill);
        return true;
    }

    public Skill getSkillFromIdent(String ident, CommandSender executor) {
        if (this.identifiers.get(ident.toLowerCase()) == null) {
            for (Skill skill : this.skills.values()) {
                if (!skill.isIdentifier(executor, ident)) continue;
                return skill;
            }
        }
        return this.identifiers.get(ident.toLowerCase());
    }

    public Collection<Skill> getSkills() {
        return Collections.unmodifiableCollection(this.skills.values());
    }

    public boolean isLoaded(String name) {
        return this.skills.containsKey(name.toLowerCase());
    }

    private String internSkillErrorMessage(String className, String helpfulError) {
        return String.format("Unable to load skill in %s -- %s Was there a Heroes update?", className, helpfulError);
    }

    private String externSkillErrorMessage(String classSimpleName, Plugin plugin, String helpfulError) {
        return String.format("Unable to load skill %s from plugin %s v%s -- %s", classSimpleName, plugin.getName(), plugin.getDescription().getVersion(), helpfulError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Skill loadSkill(File file) {
        String mainClass = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry element = entries.nextElement();
                if (!element.getName().equalsIgnoreCase("skill.info")) continue;
                BufferedReader reader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(element)));
                mainClass = reader.readLine().substring(12);
                break;
            }
            if (mainClass != null) {
                Skill skill;
                Class<?> clazz = Class.forName(mainClass, true, this.classLoader);
                Skill skill2 = skill = this.initSkill(clazz.asSubclass(Skill.class));
                return skill2;
            }
            try {
                throw new IllegalArgumentException();
            }
            catch (InstantiationException e) {
                Heroes.log(Level.WARNING, this.internSkillErrorMessage(file.getName(), "Exception in constructor."));
                Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
                Heroes.debugThrow(this.getClass().toString(), "loadSkill", e);
            }
            catch (InvocationTargetException e) {
                Heroes.log(Level.WARNING, this.internSkillErrorMessage(file.getName(), "Exception in constructor."));
                Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
                Heroes.debugThrow(this.getClass().toString(), "loadSkill", e);
            }
            catch (NoSuchMethodException e) {
                Heroes.log(Level.WARNING, this.internSkillErrorMessage(file.getName(), "Proper skill constructor not found."));
                Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
                Heroes.debugThrow(this.getClass().toString(), "loadSkill", e);
            }
            catch (NoClassDefFoundError e) {
                Heroes.log(Level.WARNING, this.internSkillErrorMessage(file.getName(), "Skill is expecting different Heroes version."));
                Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
                Heroes.debugThrow(this.getClass().toString(), "loadSkill", e);
            }
            catch (ClassNotFoundException e) {
                Heroes.log(Level.WARNING, this.internSkillErrorMessage(file.getName(), "skill.info file does not have correct class name."));
                Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
                Heroes.debugThrow(this.getClass().toString(), "loadSkill", e);
            }
            catch (IllegalArgumentException e) {
                Heroes.log(Level.WARNING, this.internSkillErrorMessage(file.getName(), "skill.info file does not have correct class name."));
                Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
                Heroes.debugThrow(this.getClass().toString(), "loadSkill", e);
            }
            catch (Exception e) {
                Heroes.log(Level.WARNING, String.format("Unable to load skill in %s.", file.getName()));
                Heroes.log(Level.WARNING, String.format("%s: %s", e.getClass().getName(), e.getMessage()));
                Heroes.debugThrow(this.getClass().toString(), "loadSkill", e);
            }
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException ignored) {
            }
            catch (NullPointerException ignored) {}
        }
        return null;
    }

    public Skill loadExternSkill(Plugin registeringPlugin, Class<? extends Skill> clazz) {
        try {
            return this.initSkill(clazz);
        }
        catch (InstantiationException e) {
            Heroes.log(Level.WARNING, this.externSkillErrorMessage(clazz.getSimpleName(), registeringPlugin, "Exception in constructor, or proper constructor not found."));
            Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
            Heroes.debugThrow(this.getClass().toString(), "loadSkills", e);
        }
        catch (InvocationTargetException e) {
            Heroes.log(Level.WARNING, this.externSkillErrorMessage(clazz.getSimpleName(), registeringPlugin, "Exception in constructor."));
            Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
            Heroes.debugThrow(this.getClass().toString(), "loadSkills", e);
        }
        catch (NoSuchMethodException e) {
            Heroes.log(Level.WARNING, this.externSkillErrorMessage(clazz.getSimpleName(), registeringPlugin, "Proper skill constructor not found. Was there a Heroes update?"));
            Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
            Heroes.debugThrow(this.getClass().toString(), "loadSkills", e);
        }
        catch (NoClassDefFoundError e) {
            Heroes.log(Level.WARNING, this.externSkillErrorMessage(clazz.getSimpleName(), registeringPlugin, "Skill is expecting different Heroes version"));
            Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
            Heroes.debugThrow(this.getClass().toString(), "loadSkills", e);
        }
        catch (Exception e) {
            Heroes.log(Level.WARNING, this.externSkillErrorMessage(clazz.getSimpleName(), registeringPlugin, String.format("Unknown error (%s: %s)", e.getClass().getName(), e.getMessage())));
            Heroes.log(Level.INFO, "For detail, ensure debug is on and inspect debug.log");
            Heroes.debugThrow(this.getClass().toString(), "loadSkills", e);
        }
        return null;
    }

    private Skill initSkill(Class<? extends Skill> skillClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Constructor<? extends Skill> ctor = skillClass.getConstructor(((Object)((Object)this.plugin)).getClass());
        Skill skill = ctor.newInstance(new Object[]{this.plugin});
        this.plugin.getSkillConfigs().loadSkillDefaults(skill);
        skill.init();
        return skill;
    }

    public void loadSkills() {
        Skill skill;
        for (Map.Entry<String, File> entry : this.skillFiles.entrySet()) {
            if (this.isLoaded(entry.getKey()) || (skill = this.loadSkill(entry.getValue())) == null) continue;
            this.addSkill(skill);
            if (!Heroes.properties.debug) continue;
            Heroes.debugLog(Level.INFO, "Skill " + skill.getName() + " Loaded");
        }
        for (SkillRegistrar.Pair pair : SkillRegistrar.getRegisteredSkillClasses()) {
            skill = this.loadExternSkill((Plugin)pair.getLeft(), (Class)pair.getRight());
            if (skill == null) continue;
            this.addSkill(skill);
            if (!Heroes.properties.debug) continue;
            Heroes.debugLog(Level.INFO, "Skill " + skill.getName() + " Loaded");
        }
        SkillRegistrar.stopRegistration();
    }

    public void removeSkill(Skill command) {
        this.skills.put(command.getName().toLowerCase().replace("skill", ""), command);
        for (String ident : command.getIdentifiers()) {
            this.identifiers.remove(ident.toLowerCase());
        }
    }

    private boolean loadSkill(String name) {
        if (this.isLoaded(name)) {
            return true;
        }
        Skill skill = this.loadSkill(this.skillFiles.get(name.toLowerCase()));
        if (skill == null) {
            return false;
        }
        this.addSkill(skill);
        return true;
    }
}

