/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters.skill;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillResult;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.DelayedTargettedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Util;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public abstract class TargettedSkill
extends ActiveSkill {
    public TargettedSkill(Heroes plugin, String name) {
        super(plugin, name);
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        ConfigurationSection section = super.getDefaultConfig();
        section.set(SkillSetting.USE_TEXT.node(), (Object)"%hero% used %skill% on %target%!");
        section.set(SkillSetting.MAX_DISTANCE.node(), (Object)15);
        return section;
    }

    @Override
    public void init() {
        String delayText = SkillConfigManager.getRaw((Skill)this, SkillSetting.DELAY_TEXT, "\u00a77[\u00a72Skill\u00a77] %hero% begins to use %skill% on %target%!");
        delayText = delayText.replace("%hero%", "$1").replace("%skill%", "$2").replace("%target%", "$3");
        this.setDelayText(delayText);
        String useText = SkillConfigManager.getRaw((Skill)this, SkillSetting.USE_TEXT.node(), "\u00a77[\u00a72Skill\u00a77] %hero% used %skill% on %target%!");
        useText = useText.replace("%hero%", "$1").replace("%skill%", "$2").replace("%target%", "$3");
        this.setUseText(useText);
    }

    public abstract SkillResult use(Hero var1, LivingEntity var2, String[] var3);

    @Override
    public SkillResult use(Hero hero, String[] args) {
        Hero tHero;
        int maxDistance = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE, 15, false);
        double distBonus = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE_INCREASE, 0.0, false) * (double)hero.getSkillLevel(this);
        maxDistance += (int)distBonus;
        if (hero.hasEffectType(EffectType.BLIND)) {
            Messaging.send((CommandSender)hero.getPlayer(), "You can't target anything while blinded!", new Object[0]);
            return SkillResult.INVALID_TARGET_NO_MSG;
        }
        LivingEntity target = this.getTarget(hero, maxDistance, args);
        if (target == null) {
            return SkillResult.INVALID_TARGET_NO_MSG;
        }
        if (args.length > 1 && target != null) {
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (target != null && target instanceof Player) {
            Hero tHero2 = this.plugin.getCharacterManager().getHero((Player)target);
            if (tHero2.hasEffectType(EffectType.UNTARGETABLE)) {
                Messaging.send((CommandSender)hero.getPlayer(), "You cannot currently target this player!", new Object[0]);
                return SkillResult.INVALID_TARGET_NO_MSG;
            }
            if (tHero2.hasEffectType(EffectType.UNTARGETABLE_NO_MSG)) {
                return SkillResult.INVALID_TARGET_NO_MSG;
            }
        }
        SkillResult result = this.use(hero, target, args);
        if (this.isType(SkillType.INTERRUPT) && result.equals(SkillResult.NORMAL) && target instanceof Player && (tHero = this.plugin.getCharacterManager().getHero((Player)target)).getDelayedSkill() != null) {
            tHero.cancelDelayedSkill();
            tHero.setCooldown("global", (long)Heroes.properties.globalCooldown + System.currentTimeMillis());
        }
        return result;
    }

    public SkillResult useDelayed(Hero hero, LivingEntity target, String[] args) {
        Hero tHero;
        Player player = hero.getPlayer();
        if (hero.hasEffectType(EffectType.BLIND)) {
            Messaging.send((CommandSender)player, "You can't target anything while blinded!", new Object[0]);
            return SkillResult.INVALID_TARGET_NO_MSG;
        }
        int maxDistance = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE, 15, false);
        maxDistance *= maxDistance;
        if (!player.getWorld().equals(target.getWorld()) || player.getLocation().distanceSquared(target.getLocation()) > (double)maxDistance) {
            Messaging.send((CommandSender)player, "Target is out of range!", new Object[0]);
            return SkillResult.FAIL;
        }
        if (target instanceof Player) {
            Hero tHero2 = this.plugin.getCharacterManager().getHero((Player)target);
            if (tHero2.hasEffectType(EffectType.UNTARGETABLE)) {
                Messaging.send((CommandSender)hero.getPlayer(), "You cannot currently target this player!", new Object[0]);
                return SkillResult.INVALID_TARGET_NO_MSG;
            }
            if (tHero2.hasEffectType(EffectType.UNTARGETABLE_NO_MSG)) {
                return SkillResult.INVALID_TARGET_NO_MSG;
            }
        }
        SkillResult result = this.use(hero, target, args);
        if (this.isType(SkillType.INTERRUPT) && result.equals(SkillResult.NORMAL) && target instanceof Player && (tHero = this.plugin.getCharacterManager().getHero((Player)target)).getDelayedSkill() != null) {
            tHero.cancelDelayedSkill();
            tHero.setCooldown("global", (long)Heroes.properties.globalCooldown + System.currentTimeMillis());
        }
        return result;
    }

    protected void broadcastExecuteText(Hero hero, LivingEntity target) {
        Player player = hero.getPlayer();
        this.broadcast(player.getLocation(), this.getUseText(), player.getDisplayName(), this.getName(), target == player ? "themself" : TargettedSkill.getEntityName(target));
    }

    public static String getEntityName(LivingEntity entity) {
        return entity instanceof Player ? ((Player)entity).getName() : entity.getClass().getSimpleName().substring(5);
    }

    public static LivingEntity getPlayerTarget(Player player, int maxDistance) {
        List lineOfSight;
        if (player.getLocation().getBlockY() > player.getLocation().getWorld().getMaxHeight()) {
            return null;
        }
        try {
            lineOfSight = player.getLineOfSight(Util.transparentIds, maxDistance);
        }
        catch (IllegalStateException e) {
            return null;
        }
        HashSet<Location> locs = new HashSet<Location>();
        for (Block block : lineOfSight) {
            locs.add(block.getRelative(BlockFace.UP).getLocation());
            locs.add(block.getLocation());
            locs.add(block.getRelative(BlockFace.DOWN).getLocation());
        }
        lineOfSight = null;
        List nearbyEntities = player.getNearbyEntities((double)maxDistance, (double)maxDistance, (double)maxDistance);
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity) || entity.isDead() || ((LivingEntity)entity).getHealth() == 0.0 || !locs.contains(entity.getLocation().getBlock().getLocation()) || entity instanceof Player && !player.canSee((Player)entity)) continue;
            return (LivingEntity)entity;
        }
        return null;
    }

    private LivingEntity getTarget(Hero hero, int maxDistance, String[] args) {
        Player player = hero.getPlayer();
        LivingEntity target = null;
        if (args.length > 0) {
            target = this.plugin.getServer().getPlayer(args[0]);
            if (target == null) {
                Messaging.send((CommandSender)player, "Invalid target!", new Object[0]);
                return null;
            }
            if (!target.getLocation().getWorld().equals(player.getLocation().getWorld())) {
                Messaging.send((CommandSender)player, "Target is in a different dimension.", new Object[0]);
                return null;
            }
            int distSq = maxDistance * maxDistance;
            if (target.getLocation().distanceSquared(player.getLocation()) > (double)distSq) {
                Messaging.send((CommandSender)player, "Target is too far away.", new Object[0]);
                return null;
            }
            if (!TargettedSkill.inLineOfSight(player, (Player)target)) {
                Messaging.send((CommandSender)player, "Sorry, target is not in your line of sight!", new Object[0]);
                return null;
            }
            if (target.isDead() || target.getHealth() == 0.0) {
                Messaging.send((CommandSender)player, "You can't target the dead!", new Object[0]);
                return null;
            }
        }
        if (target == null) {
            target = TargettedSkill.getPlayerTarget(player, maxDistance);
            if (this.isType(SkillType.HEAL)) {
                if (target instanceof Player && hero.hasParty() && hero.getParty().isPartyMember((Player)target)) {
                    return target;
                }
                if (target instanceof Player) {
                    return null;
                }
                target = null;
            }
        }
        if (target == null) {
            if (this.isType(SkillType.HARMFUL)) {
                return null;
            }
            target = player;
        }
        if (this.isType(SkillType.HARMFUL) && (player.equals(target) || hero.isOwnedSummon(target) || !TargettedSkill.damageCheck(player, target))) {
            Messaging.send((CommandSender)player, "Sorry, You can't damage that target!", new Object[0]);
            return null;
        }
        return target;
    }

    @Override
    protected boolean addDelayedSkill(Hero hero, int delay, String identifier, String[] args) {
        Player player = hero.getPlayer();
        int maxDistance = SkillConfigManager.getUseSetting(hero, (Skill)this, SkillSetting.MAX_DISTANCE, 15, false);
        LivingEntity target = this.getTarget(hero, maxDistance, args);
        if (target == null) {
            return false;
        }
        if (args.length > 1 && target != null) {
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        DelayedTargettedSkill dSkill = new DelayedTargettedSkill(identifier, hero, delay, this, target, args);
        this.broadcast(player.getLocation(), this.getDelayText(), player.getDisplayName(), this.getName(), Messaging.getLivingEntityName(target));
        this.plugin.getCharacterManager().queueDelayedSkill(dSkill);
        hero.setDelayedSkill(dSkill);
        return true;
    }

    public static boolean inLineOfSight(Player a, Player b) {
        Location bLoc;
        if (a == b || a.equals(b)) {
            return true;
        }
        Location aLoc = a.getEyeLocation();
        int distance = (int)aLoc.distance(bLoc = b.getEyeLocation());
        if (distance > 120) {
            return false;
        }
        Vector ab = new Vector(bLoc.getX() - aLoc.getX(), bLoc.getY() - aLoc.getY(), bLoc.getZ() - aLoc.getZ());
        try {
            BlockIterator iterator = new BlockIterator(a.getWorld(), aLoc.toVector(), ab, 0.0, distance + 1);
            while (iterator.hasNext()) {
                Block block = (Block)iterator.next();
                Material type = block.getType();
                if (Util.transparentBlocks.contains(type)) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

