/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command;

import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.command.InteractiveCommand;
import com.herocraftonline.heroes.command.InteractiveCommandState;
import com.herocraftonline.heroes.util.Messaging;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;

public abstract class BasicInteractiveCommand
extends BasicCommand
implements InteractiveCommand {
    private InteractiveCommandState[] states = new InteractiveCommandState[0];
    private final Map<CommandSender, Integer> userStates = new HashMap<CommandSender, Integer>();

    public BasicInteractiveCommand(String name) {
        super(name);
    }

    @Override
    public final void cancelInteraction(CommandSender executor) {
        this.userStates.remove(executor);
        this.onCommandCancelled(executor);
    }

    @Override
    public final boolean execute(CommandSender executor, String identifier, String[] args) {
        if (this.states.length == 0) {
            throw new IllegalArgumentException("An interactive command must have at least one state.");
        }
        int stateIndex = 0;
        if (this.userStates.containsKey(executor)) {
            stateIndex = this.userStates.get(executor);
        }
        InteractiveCommandState state = this.states[stateIndex];
        if (stateIndex > 0 && this.getCancelIdentifier().equalsIgnoreCase(identifier)) {
            Messaging.send(executor, "Exiting command.", new Object[0]);
            this.userStates.remove(executor);
            this.onCommandCancelled(executor);
            return true;
        }
        if (args.length < state.getMinArguments() || args.length > state.getMaxArguments() || !state.execute(executor, identifier, args)) {
            if (stateIndex > 0 && this.userStates.containsKey(executor)) {
                Messaging.send(executor, "Invalid input - try again or type $1 to exit.", "/" + this.getCancelIdentifier());
            }
        } else if (this.states.length > ++stateIndex) {
            this.userStates.put(executor, stateIndex++);
        } else {
            this.userStates.remove(executor);
        }
        return true;
    }

    @Override
    public final boolean isIdentifier(CommandSender executor, String input) {
        int stateIndex = 0;
        if (this.userStates.containsKey(executor)) {
            stateIndex = this.userStates.get(executor);
        }
        if (stateIndex > 0 && this.getCancelIdentifier().equalsIgnoreCase(input)) {
            return true;
        }
        InteractiveCommandState state = this.states[stateIndex];
        return state.isIdentifier(input);
    }

    @Override
    public final boolean isInProgress(CommandSender executor) {
        return this.userStates.containsKey(executor);
    }

    @Override
    public final boolean isInteractive() {
        return true;
    }

    @Override
    public final void setArgumentRange(int min, int max) {
    }

    @Override
    public final void setIdentifiers(String ... identifiers) {
    }

    public final void setStates(InteractiveCommandState ... states) {
        if (states.length == 0) {
            throw new IllegalArgumentException("An interactive command must have at least one state.");
        }
        this.states = states;
        super.setArgumentRange(states[0].getMinArguments(), states[0].getMaxArguments());
    }
}

