/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.Command;
import com.herocraftonline.heroes.util.Messaging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler {
    protected LinkedHashMap<String, Command> commands;
    protected HashMap<String, Command> identifiers;
    private final Heroes plugin;

    public CommandHandler(Heroes plugin) {
        this.plugin = plugin;
        this.commands = new LinkedHashMap();
        this.identifiers = new HashMap();
    }

    public void addCommand(Command command) {
        this.commands.put(command.getName().toLowerCase(), command);
        for (String ident : command.getIdentifiers()) {
            this.identifiers.put(ident.toLowerCase(), command);
        }
    }

    public boolean dispatch(CommandSender sender, String commandName, String label, String[] args) {
        for (int argsIncluded = args.length; argsIncluded >= 0; --argsIncluded) {
            StringBuilder identifierBuilder = new StringBuilder(commandName);
            for (int i = 0; i < argsIncluded; ++i) {
                identifierBuilder.append(' ').append(args[i]);
            }
            String identifier = identifierBuilder.toString();
            Command cmd = this.getCmdFromIdent(identifier, sender);
            if (cmd == null) continue;
            String[] realArgs = Arrays.copyOfRange(args, argsIncluded, args.length);
            if (!cmd.isInProgress(sender)) {
                if (realArgs.length < cmd.getMinArguments() || realArgs.length > cmd.getMaxArguments()) {
                    this.displayCommandHelp(cmd, sender);
                    return true;
                }
                if (realArgs.length > 0 && realArgs[0].equals("?")) {
                    this.displayCommandHelp(cmd, sender);
                    return true;
                }
            }
            if (!CommandHandler.hasPermission(sender, cmd.getPermission())) {
                Messaging.send(sender, "Insufficient permission.", new Object[0]);
                return true;
            }
            cmd.execute(sender, identifier, realArgs);
            return true;
        }
        if (label.equalsIgnoreCase("skill")) {
            Messaging.send(sender, "That skill does not exist!", new Object[0]);
        } else {
            Messaging.send(sender, "Unrecognized command!", new Object[0]);
        }
        return true;
    }

    private void displayCommandHelp(Command cmd, CommandSender sender) {
        sender.sendMessage("\u00a7cCommand:\u00a7e " + cmd.getName());
        if (sender instanceof Player && cmd instanceof Skill) {
            Hero hero = this.plugin.getCharacterManager().getHero((Player)sender);
            sender.sendMessage("\u00a7cDescription:\u00a7e " + ((Skill)cmd).getDescription(hero));
        } else {
            sender.sendMessage("\u00a7cDescription:\u00a7e " + cmd.getDescription());
        }
        sender.sendMessage("\u00a7cUsage:\u00a7e " + cmd.getUsage());
        if (cmd.getNotes() != null) {
            for (String note : cmd.getNotes()) {
                sender.sendMessage("\u00a7e" + note);
            }
        }
    }

    public Command getCmdFromIdent(String ident, CommandSender executor) {
        Skill skill = this.plugin.getSkillManager().getSkillFromIdent(ident, executor);
        if (skill != null) {
            return skill;
        }
        if (this.identifiers.get(ident.toLowerCase()) == null) {
            for (Command cmd : this.commands.values()) {
                if (!cmd.isIdentifier(executor, ident)) continue;
                return cmd;
            }
        }
        return this.identifiers.get(ident.toLowerCase());
    }

    public Command getCommand(String name) {
        return this.commands.get(name.toLowerCase());
    }

    public List<Command> getCommands() {
        return new ArrayList<Command>(this.commands.values());
    }

    public void removeCommand(Command command) {
        this.commands.remove(command.getName().toLowerCase());
        for (String ident : command.getIdentifiers()) {
            this.identifiers.remove(ident.toLowerCase());
        }
    }

    public static boolean hasPermission(CommandSender sender, String permission) {
        if (!(sender instanceof Player) || permission == null || permission.isEmpty()) {
            return true;
        }
        Player player = (Player)sender;
        return player.isOp() || Heroes.perms.has(player, permission);
    }
}

