/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;

public class AdminBonusCommand
extends BasicCommand {
    private final DateFormat dateFormatter = new SimpleDateFormat("MM.dd HH:mm");

    public AdminBonusCommand(Heroes plugin) {
        super("AdminBonusCommand");
        this.setDescription("Changes a users class");
        this.setUsage("/hero bonus \u00a79<time|message|exp-mult> <value>");
        this.setArgumentRange(2, 1000);
        this.setIdentifiers("hero bonus");
        this.setPermission("heroes.admin.bonus");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (args[0].equalsIgnoreCase("time")) {
            this.time(sender, args[1]);
        } else if (args[0].equalsIgnoreCase("message")) {
            this.messageChange(sender, args);
        } else if (args[0].equalsIgnoreCase("exp-mult")) {
            this.expMult(sender, args[1]);
        } else {
            sender.sendMessage(this.getUsage());
        }
        return true;
    }

    private void time(CommandSender sender, String arg) {
        int amount;
        GregorianCalendar cal = new GregorianCalendar();
        Integer field = null;
        Pattern pattern = Pattern.compile("(?i)(\\d+)(.+)", 2);
        Matcher matcher = pattern.matcher(arg);
        if (matcher.find()) {
            amount = 0;
            try {
                amount = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                Messaging.send(sender, "Invalid timing given for exp bonus", new Object[0]);
                return;
            }
            arg = matcher.group(2);
            if (arg.equalsIgnoreCase("min")) {
                field = 12;
            } else if (arg.equalsIgnoreCase("s")) {
                field = 13;
            } else if (arg.equalsIgnoreCase("h")) {
                field = 11;
            } else if (arg.equalsIgnoreCase("d")) {
                field = 6;
            } else if (arg.equalsIgnoreCase("w")) {
                field = 3;
            } else if (arg.equalsIgnoreCase("m")) {
                field = 2;
            }
            if (field == null) {
                Messaging.send(sender, "Invalid time-type given, use: min - Minutes, s - Seconds, h - Hours, d - Days, w - Weeks, m - Month", new Object[0]);
                return;
            }
        } else {
            Messaging.send(sender, "Current bonus expiration is set to: ", this.dateFormatter.format(new Date(Heroes.properties.expiration)));
            return;
        }
        ((Calendar)cal).add(field, amount);
        Heroes.properties.expiration = cal.getTimeInMillis();
        Messaging.send(sender, "You have reset the bonus expiration to: $1", this.dateFormatter.format(cal.getTime()));
        Heroes.properties.saveConfig();
    }

    private void expMult(CommandSender sender, String arg) {
        try {
            double val;
            Heroes.properties.expBonus = val = Double.valueOf(arg).doubleValue();
        }
        catch (NumberFormatException e) {
            Messaging.send(sender, "$1 is not a valid exp multiplier", arg);
            return;
        }
        Messaging.send(sender, "The experience bonus was set to $1", Heroes.properties.expBonus);
        Heroes.properties.saveConfig();
    }

    private void messageChange(CommandSender sender, String[] args) {
        StringBuilder msg = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            msg.append(args[i]).append(' ');
        }
        Heroes.properties.bonusMessage = msg.toString().trim();
        Heroes.properties.saveConfig();
        Messaging.send(sender, "Bonus message was set to: $1", msg.toString().trim());
    }
}

