/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminExpCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminExpCommand(Heroes plugin) {
        super("AdminExpCommand");
        this.plugin = plugin;
        this.setDescription("Changes a users class exp");
        this.setUsage("/hero admin exp \u00a79<player> <class> <exp>");
        this.setArgumentRange(3, 3);
        this.setIdentifiers("hero admin exp");
        this.setPermission("heroes.admin.exp");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            Messaging.send(sender, "Failed to find a matching Player for '$1'.  Offline players are not supported!", args[0]);
            return false;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroClass hc = this.plugin.getClassManager().getClass(args[1]);
        if (hc == null) {
            if (args[1].equalsIgnoreCase("prim")) {
                hc = hero.getHeroClass();
            } else if (args[1].equalsIgnoreCase("prof")) {
                hc = hero.getSecondClass();
            }
        }
        if (hc == null) {
            Messaging.send(sender, "$1 is not a valid HeroClass!", args[1]);
            return false;
        }
        try {
            double expChange = Integer.parseInt(args[2]);
            hero.addExp(expChange, hc, hero.getPlayer().getLocation());
            this.plugin.getCharacterManager().saveHero(hero, false);
            Messaging.send(sender, "Experience changed.", new Object[0]);
            Messaging.send((CommandSender)hero.getPlayer(), "You have been awarded $1 exp", expChange);
            return true;
        }
        catch (NumberFormatException e) {
            Messaging.send(sender, "Invalid experience value.", new Object[0]);
            return false;
        }
    }
}

