/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class AdminHealCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminHealCommand(Heroes plugin) {
        super("AdminHeal");
        this.plugin = plugin;
        this.setDescription("Heals a hero to full health");
        this.setUsage("/hero admin heal \u00a79<player>");
        this.setArgumentRange(0, 3);
        this.setIdentifiers("hero admin heal");
        this.setPermission("heroes.admin.heal");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (args.length > 0) {
            List players = this.plugin.getServer().matchPlayer(args[0]);
            if (players.isEmpty()) {
                Messaging.send(sender, "No player named $1 was found!", args[0]);
                return true;
            }
            StringBuilder names = new StringBuilder();
            for (Player player : players) {
                player.setHealth(player.getMaxHealth());
                Messaging.send((CommandSender)player, "The gods have miraculously healed you!", new Object[0]);
                names.append(player.getDisplayName()).append("  ");
            }
            Messaging.send(sender, "You have restored: $1to full health.", names.toString());
            return true;
        }
        if (sender instanceof ConsoleCommandSender) {
            Messaging.send(sender, "You must specify a player to heal.", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        player.setHealth(player.getMaxHealth());
        Messaging.send(sender, "You have been restored to full health!", new Object[0]);
        return true;
    }
}

