/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminHealthCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminHealthCommand(Heroes plugin) {
        super("AdminHealthCommand");
        this.plugin = plugin;
        this.setDescription("Sets a user's health");
        this.setUsage("/hero admin hp \u00a79<player> <health>");
        this.setArgumentRange(2, 2);
        this.setIdentifiers("hero admin hp");
        this.setPermission("heroes.admin.health");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        double health;
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            Messaging.send(sender, "Failed to find a matching Player for $1. Offline players are not supported!", args[0]);
            return false;
        }
        try {
            health = Integer.valueOf(args[1]).intValue();
        }
        catch (NumberFormatException e) {
            Messaging.send(sender, "Invalid health.", new Object[0]);
            return false;
        }
        if (health > player.getMaxHealth()) {
            health = player.getMaxHealth();
        }
        player.setHealth(health);
        Messaging.send(sender, "You have successfully changed $1's health.", player.getName());
        return true;
    }
}

