/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminLevelCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminLevelCommand(Heroes plugin) {
        super("AdminLevelCommand");
        this.plugin = plugin;
        this.setDescription("Changes a users level");
        this.setUsage("/hero admin level \u00a79<player> <class> <level>");
        this.setArgumentRange(3, 3);
        this.setIdentifiers("hero admin level");
        this.setPermission("heroes.admin.level");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            Messaging.send(sender, "Failed to find a matching Player for '$1'.  Offline players are not supported!", args[0]);
            return false;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroClass hc = this.plugin.getClassManager().getClass(args[1]);
        if (hc == null) {
            if (args[1].equalsIgnoreCase("prim")) {
                hc = hero.getHeroClass();
            } else if (args[1].equalsIgnoreCase("prof")) {
                hc = hero.getSecondClass();
            }
        }
        if (hc == null) {
            Messaging.send(sender, "$1 is not a valid HeroClass!", args[1]);
            return false;
        }
        try {
            int levelChange = Integer.parseInt(args[2]);
            if (levelChange < 1) {
                throw new NumberFormatException();
            }
            int experience = Properties.levels[levelChange - 1];
            hero.addExp((double)experience - hero.getExperience(hc), hc, hero.getPlayer().getLocation());
            this.plugin.getCharacterManager().saveHero(hero, false);
            Messaging.send(sender, "Level changed.", new Object[0]);
            return true;
        }
        catch (NumberFormatException e) {
            Messaging.send(sender, "Invalid level value.", new Object[0]);
            return false;
        }
    }
}

