/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class AdminManaCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminManaCommand(Heroes plugin) {
        super("AdminMana");
        this.plugin = plugin;
        this.setDescription("Restores a heros mana to full");
        this.setUsage("/hero admin mana \u00a79<player>");
        this.setArgumentRange(0, 3);
        this.setIdentifiers("hero admin mana");
        this.setPermission("heroes.admin.mana");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (args.length > 0) {
            List players = this.plugin.getServer().matchPlayer(args[0]);
            if (players.isEmpty()) {
                Messaging.send(sender, "No player named $1 was found!", args[0]);
                return true;
            }
            StringBuilder names = new StringBuilder();
            for (Player player : players) {
                Hero hero = this.plugin.getCharacterManager().getHero(player);
                hero.setMana(hero.getMaxMana());
                Messaging.send((CommandSender)player, "The gods have restored your mana!", new Object[0]);
                names.append(player.getDisplayName()).append("  ");
            }
            Messaging.send(sender, "You have restored: $1's mana to full.", names.toString());
            return true;
        }
        if (sender instanceof ConsoleCommandSender) {
            Messaging.send(sender, "You must specify a player to restore mana to.", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        hero.setMana(hero.getMaxMana());
        Messaging.send(sender, "Your mana has been restored to full!", new Object[0]);
        return true;
    }
}

