/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AdminProfCommand
extends BasicCommand {
    private final Heroes plugin;

    public AdminProfCommand(Heroes plugin) {
        super("AdminClassCommand");
        this.plugin = plugin;
        this.setDescription("Changes a users secondary class");
        this.setUsage("/hero admin prof \u00a79<player> <class>");
        this.setArgumentRange(2, 2);
        this.setIdentifiers("hero admin prof");
        this.setPermission("heroes.admin.prof");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player = this.plugin.getServer().getPlayer(args[0]);
        if (player == null) {
            Messaging.send(sender, "Failed to find a matching Player for '$1'. Offline players are not supported!", args[0]);
            return true;
        }
        HeroClass heroClass = this.plugin.getClassManager().getClass(args[1]);
        if (heroClass == null) {
            Messaging.send(sender, "Failed to find a matching HeroClass for '$1'.", args[1]);
            return true;
        }
        if (!heroClass.isSecondary()) {
            Messaging.send(sender, "$1 is not a secondary class!", args[1]);
            return true;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (heroClass.equals(hero.getSecondClass())) {
            Messaging.send(sender, "$1 is already a $2.", player.getName(), heroClass.getName());
            return true;
        }
        ClassChangeEvent event = new ClassChangeEvent(hero, hero.getSecondClass(), heroClass, 0.0, false, false);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            Messaging.send(sender, "Failed to set the player to that class due to class restrictons.", new Object[0]);
            return true;
        }
        hero.changeHeroClass(heroClass, true);
        Messaging.send(sender, "You have successfully changed $1 HeroClass to $2.", player.getName(), heroClass.getName());
        Messaging.send((CommandSender)player, "Welcome to the path of the $1!", heroClass.getName());
        return true;
    }
}

