/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.PassiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BindSkillCommand
extends BasicCommand {
    private final Heroes plugin;

    public BindSkillCommand(Heroes plugin) {
        super("BindSkill");
        this.plugin = plugin;
        this.setDescription("Binds a skill with an item");
        this.setUsage("/bind \u00a79<skill> \u00a78[args]");
        this.setArgumentRange(0, 1000);
        this.setIdentifiers("bind", "unbind");
        this.setPermission("heroes.bind");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        Material material = player.getItemInHand().getType();
        if (!hero.canEquipItem(player.getInventory().getHeldItemSlot())) {
            return false;
        }
        if (args.length > 0) {
            Skill skill = this.plugin.getSkillManager().getSkill(args[0]);
            if (skill == null) {
                skill = this.plugin.getSkillManager().getSkillFromIdent("skill " + args[0], sender);
            }
            if (skill != null && hero.canUseSkill(skill.getName())) {
                if (skill instanceof PassiveSkill || skill instanceof OutsourcedSkill) {
                    Messaging.send((CommandSender)player, "You can not bind passive skills!", new Object[0]);
                    return false;
                }
                if (skill.isType(SkillType.UNBINDABLE)) {
                    Messaging.send((CommandSender)player, "You can not bind that skill!", new Object[0]);
                    return false;
                }
                if (material == Material.AIR) {
                    Messaging.send(sender, "You must be holding an item to bind a skill!", new Object[0]);
                    return false;
                }
                args[0] = skill.getName();
                hero.bind(material, args);
                Messaging.send(sender, "$1 has been bound to $2.", MaterialUtil.getFriendlyName(material), skill.getName());
            } else {
                Messaging.send(sender, "That skill does not exist for your class.", new Object[0]);
            }
        } else {
            hero.unbind(material);
            Messaging.send(sender, "$1 is no longer bound to a skill.", MaterialUtil.getFriendlyName(material));
        }
        return true;
    }
}

