/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.command.Command;
import com.herocraftonline.heroes.command.CommandHandler;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;

public class HelpCommand
extends BasicCommand {
    private static final int CMDS_PER_PAGE = 8;
    private final Heroes plugin;

    public HelpCommand(Heroes plugin) {
        super("Help");
        this.plugin = plugin;
        this.setDescription("Displays the help menu");
        this.setUsage("/hero help \u00a78[page#]");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("hero", "hero help");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        int page = 0;
        if (args.length != 0) {
            try {
                page = Integer.parseInt(args[0]) - 1;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        List<Command> sortCommands = this.plugin.getCommandHandler().getCommands();
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Command command : sortCommands) {
            if (!command.isShownOnHelpMenu() || !CommandHandler.hasPermission(sender, command.getPermission())) continue;
            commands.add(command);
        }
        int numPages = commands.size() / 8;
        if (commands.size() % 8 != 0) {
            ++numPages;
        }
        if (page >= numPages || page < 0) {
            page = 0;
        }
        sender.sendMessage("\u00a7c-----[ \u00a7fHeroes Help <" + (page + 1) + "/" + numPages + ">\u00a7c ]-----");
        int start = page * 8;
        int end = start + 8;
        if (end > commands.size()) {
            end = commands.size();
        }
        for (int c = start; c < end; ++c) {
            Command cmd = (Command)commands.get(c);
            sender.sendMessage("  \u00a7a" + cmd.getUsage());
        }
        sender.sendMessage("\u00a7cFor more info on a particular command, type \u00a7f/<command> ?");
        return true;
    }
}

