/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LevelInformationCommand
extends BasicCommand {
    private final Heroes plugin;

    public LevelInformationCommand(Heroes plugin) {
        super("Level Information");
        this.plugin = plugin;
        this.setDescription("Displays hero information");
        this.setUsage("/hero level [toggle]");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("hero level", "level", "lvl");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (args.length > 0 && args[0].equalsIgnoreCase("toggle")) {
            hero.setSyncPrimary(!hero.isSyncPrimary());
            Messaging.send((CommandSender)player, "Your experience bar is now synced with $1", hero.isSyncPrimary() ? hero.getHeroClass().getName() : hero.getSecondClass().getName());
            return true;
        }
        if (args.length > 0) {
            Messaging.send((CommandSender)player, this.getUsage(), new Object[0]);
            return true;
        }
        HeroClass hc = hero.getHeroClass();
        int exp = (int)hero.getExperience(hc);
        int level = Properties.getLevel(exp);
        int current = Properties.getTotalExp(level);
        HeroClass sClass = hero.getSecondClass();
        String secondClassName = sClass != null ? " | " + sClass.getName() : "";
        String secondLevelInfo = sClass != null ? " | " + hero.getLevel(sClass) + ChatColor.GREEN + "/" + ChatColor.WHITE + sClass.getMaxLevel() : "";
        String secondExp = sClass != null ? " | " + (int)hero.getExperience(sClass) : "";
        sender.sendMessage(ChatColor.RED + "-----[ " + ChatColor.WHITE + "Your Level Information" + ChatColor.RED + " ]-----");
        sender.sendMessage(ChatColor.GREEN + "  Class: " + ChatColor.WHITE + hc.getName() + secondClassName);
        sender.sendMessage(ChatColor.GREEN + "  Level: " + ChatColor.WHITE + level + ChatColor.GREEN + "/" + ChatColor.WHITE + hc.getMaxLevel() + secondLevelInfo);
        sender.sendMessage(ChatColor.GREEN + "  Total Exp: " + ChatColor.WHITE + exp + secondExp);
        if (!hero.isMaster(hc)) {
            int next = Properties.getTotalExp(level + 1);
            sender.sendMessage(ChatColor.DARK_GREEN + "  EXP.  " + Messaging.createExperienceBar(exp, current, next));
        } else {
            sender.sendMessage(ChatColor.YELLOW + "  MASTERED!");
        }
        return true;
    }
}

